/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.RCGuiTables;
import ivorius.reccomplex.gui.TableDataSourceBlockPos;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationType;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.ListGeneration;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;

public class TableDataSourceStructureListGeneration
extends TableDataSourceSegmented {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private ListGeneration generationInfo;

    public TableDataSourceStructureListGeneration(TableNavigator navigator, TableDelegate tableDelegate, ListGeneration generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = tableDelegate;
        this.generationInfo = generationInfo;
        this.addManagedSegment(0, new TableDataSourceGenerationType(generationInfo, navigator, tableDelegate));
        this.addManagedSegment(3, new TableDataSourceBlockPos(generationInfo.shift, generationInfo::setShift, null, null, null, IvTranslations.get("reccomplex.generationInfo.structureList.shift.x"), IvTranslations.get("reccomplex.generationInfo.structureList.shift.y"), IvTranslations.get("reccomplex.generationInfo.structureList.shift.z")));
    }

    @Override
    public int numberOfSegments() {
        return 5;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 1;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                TableCellString cell = new TableCellString("listID", this.generationInfo.listID);
                cell.setShowsValidityState(true);
                cell.setValidityState(this.currentStructureListIDState());
                cell.addPropertyConsumer(cell1 -> {
                    this.generationInfo.listID = (String)cell.getPropertyValue();
                    cell.setValidityState(this.currentStructureListIDState());
                });
                return new TitledCell(IvTranslations.get("reccomplex.generationInfo.structureList.id"), cell);
            }
            case 2: {
                return RCGuiTables.defaultWeightElement(val -> {
                    this.generationInfo.weight = TableCells.toDouble(val);
                }, this.generationInfo.weight);
            }
            case 4: {
                TableCellEnum<EnumFacing> cell = new TableCellEnum<EnumFacing>("front", this.generationInfo.front, TableDirections.getDirectionOptions(Directions.HORIZONTAL));
                cell.addPropertyConsumer(cell1 -> {
                    this.generationInfo.front = (EnumFacing)cell.getPropertyValue();
                });
                return new TitledCell(IvTranslations.get("reccomplex.generationInfo.structureList.front"), cell);
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }

    @Nonnull
    protected GuiValidityStateIndicator.State currentStructureListIDState() {
        return Structures.isSimpleID(this.generationInfo.listID) ? (StructureRegistry.INSTANCE.getStructuresInList(this.generationInfo.listID, null).count() > 0L ? GuiValidityStateIndicator.State.VALID : GuiValidityStateIndicator.State.SEMI_VALID) : GuiValidityStateIndicator.State.INVALID;
    }
}

