/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.RCGuiTables;
import ivorius.reccomplex.gui.editstructure.TableDataSourceBiomeGenList;
import ivorius.reccomplex.gui.editstructure.TableDataSourceDimensionGenList;
import ivorius.reccomplex.gui.editstructure.TableDataSourceNaturalGenLimitation;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationType;
import ivorius.reccomplex.gui.editstructure.placer.TableDataSourcePlacer;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TableCellMultiBuilder;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.selector.NaturalStructureSelector;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.NaturalGeneration;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class TableDataSourceNaturalGeneration
extends TableDataSourceSegmented {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private NaturalGeneration generationInfo;

    public TableDataSourceNaturalGeneration(TableNavigator navigator, TableDelegate delegate, NaturalGeneration generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = delegate;
        this.generationInfo = generationInfo;
        this.addManagedSegment(0, new TableDataSourceGenerationType(generationInfo, navigator, delegate));
        this.addManagedSegment(3, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourcePlacer(generationInfo.placer, delegate, navigator)).buildDataSource(IvTranslations.get("reccomplex.placer"), IvTranslations.getLines("reccomplex.placer.tooltip")));
        this.addManagedSegment(4, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceBiomeGenList(generationInfo.biomeWeights, delegate, navigator), () -> IvTranslations.get("reccomplex.gui.biomes")).buildDataSource());
        this.addManagedSegment(5, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceDimensionGenList(generationInfo.dimensionWeights, delegate, navigator), () -> IvTranslations.get("reccomplex.gui.dimensions")).buildDataSource());
        this.addManagedSegment(6, TableCellMultiBuilder.create(navigator, delegate).addNavigation(() -> new TableDataSourceNaturalGenLimitation(generationInfo.spawnLimitation, delegate), () -> IvTranslations.get("reccomplex.generationInfo.natural.limitations")).enabled(generationInfo::hasLimitations).addAction(() -> {
            generationInfo.spawnLimitation = generationInfo.hasLimitations() ? null : new NaturalGeneration.SpawnLimitation();
        }, () -> generationInfo.hasLimitations() ? IvTranslations.get("reccomplex.gui.remove") : IvTranslations.get("reccomplex.gui.add"), null).buildDataSource());
    }

    public static List<TableCellEnum.Option<String>> allGenerationCategories() {
        Set<String> categories = NaturalStructureSelector.CATEGORY_REGISTRY.activeIDs();
        return categories.stream().map(category -> Pair.of((Object)category, (Object)NaturalStructureSelector.CATEGORY_REGISTRY.getActive((String)category))).filter(p -> ((NaturalStructureSelector.Category)p.getRight()).selectableInGUI()).map(p -> new TableCellEnum.Option<Object>(p.getLeft(), ((NaturalStructureSelector.Category)p.getRight()).title(), ((NaturalStructureSelector.Category)p.getRight()).tooltip())).sorted(Comparator.comparing(o -> o.title)).collect(Collectors.toList());
    }

    @Override
    public int numberOfSegments() {
        return 7;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: 
            case 2: {
                return 1;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                TableCellEnum<String> cell = new TableCellEnum<String>("category", this.generationInfo.generationCategory, TableDataSourceNaturalGeneration.allGenerationCategories());
                cell.addPropertyConsumer(val -> {
                    this.generationInfo.generationCategory = val;
                });
                return new TitledCell(IvTranslations.get("reccomplex.generationInfo.natural.category"), cell);
            }
            case 2: {
                return RCGuiTables.defaultWeightElement(val -> this.generationInfo.setGenerationWeight(TableCells.toDouble(val)), this.generationInfo.getGenerationWeight());
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

