/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.RCGuiTables;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationType;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceMazeComponent;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.MazeGeneration;

public class TableDataSourceMazeGeneration
extends TableDataSourceSegmented {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private MazeGeneration generationInfo;

    public TableDataSourceMazeGeneration(TableNavigator navigator, TableDelegate tableDelegate, MazeGeneration generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = tableDelegate;
        this.generationInfo = generationInfo;
        this.addManagedSegment(0, new TableDataSourceGenerationType(generationInfo, navigator, tableDelegate));
        this.addManagedSegment(3, new TableDataSourceMazeComponent(generationInfo.mazeComponent, navigator, tableDelegate));
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: 
            case 2: {
                return 1;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                TableCellString cell = new TableCellString("mazeID", this.generationInfo.mazeID);
                cell.setValidityState(MazeGeneration.idValidity((String)cell.getPropertyValue()));
                cell.addPropertyConsumer(mazeID -> {
                    this.generationInfo.setMazeID((String)mazeID);
                    cell.setValidityState(MazeGeneration.idValidity((String)cell.getPropertyValue()));
                });
                return new TitledCell(IvTranslations.get("reccomplex.generationInfo.mazeComponent.mazeid"), cell);
            }
            case 2: {
                return RCGuiTables.defaultWeightElement(val -> {
                    this.generationInfo.weight = TableCells.toDouble(val);
                }, this.generationInfo.weight);
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

