/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.reccomplex.gui.editstructure.TableDataSourceWeightedBlockState;
import ivorius.reccomplex.gui.editstructure.preset.TableDataSourcePresettedList;
import ivorius.reccomplex.gui.editstructure.preset.TableDataSourcePresettedObject;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.utils.RCStrings;
import ivorius.reccomplex.utils.presets.PresettedList;
import ivorius.reccomplex.world.gen.feature.structure.generic.WeightedBlockState;
import javax.annotation.Nonnull;
import net.minecraft.init.Blocks;
import net.minecraft.util.text.TextFormatting;

public class TableDataSourceWeightedBlockStateList
extends TableDataSourceSegmented {
    public TableDataSourceWeightedBlockStateList(PresettedList<WeightedBlockState> list, TableDelegate delegate, TableNavigator navigator) {
        this.addManagedSegment(0, new TableDataSourcePresettedObject<WeightedBlockState>(list, "block_preset", delegate, navigator).withApplyPresetAction(() -> this.addPresetSegments(list, delegate, navigator)));
        this.addPresetSegments(list, delegate, navigator);
    }

    public void addPresetSegments(PresettedList<WeightedBlockState> list, final TableDelegate delegate, TableNavigator navigator) {
        TableDataSourcePresettedList<WeightedBlockState> listSource = new TableDataSourcePresettedList<WeightedBlockState>(list, delegate, navigator){

            @Override
            public String getDisplayString(WeightedBlockState entry) {
                if (entry.state == null) {
                    return String.format("None (%.2f)", entry.getWeight());
                }
                return String.format("%s$%d (%.2f)", RCStrings.abbreviateFormatted(entry.state.func_177230_c().func_149732_F(), 16), BlockStates.toMetadata(entry.state), entry.getWeight());
            }

            @Override
            public WeightedBlockState newEntry(String actionID) {
                return new WeightedBlockState(null, Blocks.field_150348_b.func_176223_P(), null);
            }

            @Override
            @Nonnull
            public TableCell entryCell(boolean enabled, WeightedBlockState weightedBlockState) {
                return TableCells.edit(enabled, this.navigator, delegate, () -> new TableDataSourceWeightedBlockState(weightedBlockState, this.navigator, this.tableDelegate));
            }

            @Override
            public WeightedBlockState copyEntry(WeightedBlockState weightedBlockState) {
                return weightedBlockState.copy();
            }
        };
        listSource.setDuplicateTitle(TextFormatting.GREEN + "D");
        this.addManagedSegment(1, listSource);
    }

    @Override
    @Nonnull
    public String title() {
        return "Blocks";
    }
}

