/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui;

import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellInteger;
import ivorius.reccomplex.gui.table.cell.TableCellStringInt;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class TableDataSourceBlockSurfacePos
extends TableDataSourceSegmented {
    private BlockSurfacePos coord;
    private Consumer<BlockSurfacePos> consumer;
    private IntegerRange rangeX;
    private IntegerRange rangeZ;
    private String titleX;
    private String titleZ;

    public TableDataSourceBlockSurfacePos(BlockSurfacePos coord, Consumer<BlockSurfacePos> consumer, IntegerRange rangeX, IntegerRange rangeZ, String titleX, String titleZ) {
        this.coord = coord;
        this.consumer = consumer;
        this.rangeX = rangeX;
        this.rangeZ = rangeZ;
        this.titleX = titleX;
        this.titleZ = titleZ;
    }

    public TableDataSourceBlockSurfacePos(BlockSurfacePos coord, Consumer<BlockSurfacePos> consumer, IntegerRange range, String titleFormat) {
        this.coord = coord;
        this.consumer = consumer;
        this.rangeX = range;
        this.rangeZ = range;
        this.titleX = String.format(titleFormat, "X");
        this.titleZ = String.format(titleFormat, "Z");
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return 2;
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        String title;
        int val;
        IntegerRange range;
        switch (index) {
            case 0: {
                range = this.rangeX;
                val = this.coord.getX();
                title = this.titleX;
                break;
            }
            default: {
                range = this.rangeZ;
                val = this.coord.getZ();
                title = this.titleZ;
            }
        }
        if (range != null) {
            TableCellInteger cell = new TableCellInteger(null, val, range.min, range.max);
            cell.addPropertyConsumer(this.createConsumer(index));
            return new TitledCell(title, cell);
        }
        TableCellStringInt cell = new TableCellStringInt(null, val);
        cell.addPropertyConsumer(this.createConsumer(index));
        return new TitledCell(title, cell);
    }

    @Nonnull
    protected Consumer<Integer> createConsumer(int idx) {
        return val -> {
            this.coord = new BlockSurfacePos(idx == 0 ? val.intValue() : this.coord.getX(), idx == 1 ? val.intValue() : this.coord.getZ());
            this.consumer.accept(this.coord);
        };
    }
}

