/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui;

import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellInteger;
import ivorius.reccomplex.gui.table.cell.TableCellStringInt;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;

public class TableDataSourceBlockPos
extends TableDataSourceSegmented {
    private BlockPos coord;
    private Consumer<BlockPos> consumer;
    private IntegerRange rangeX;
    private IntegerRange rangeY;
    private IntegerRange rangeZ;
    private String titleX;
    private String titleY;
    private String titleZ;

    public TableDataSourceBlockPos(BlockPos coord, Consumer<BlockPos> consumer, IntegerRange rangeX, IntegerRange rangeY, IntegerRange rangeZ, String titleX, String titleY, String titleZ) {
        this.coord = coord;
        this.consumer = consumer;
        this.rangeX = rangeX;
        this.rangeY = rangeY;
        this.rangeZ = rangeZ;
        this.titleX = titleX;
        this.titleY = titleY;
        this.titleZ = titleZ;
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return 3;
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        String title;
        int val;
        IntegerRange range;
        switch (index) {
            case 0: {
                range = this.rangeX;
                val = this.coord.func_177958_n();
                title = this.titleX;
                break;
            }
            case 1: {
                range = this.rangeY;
                val = this.coord.func_177956_o();
                title = this.titleY;
                break;
            }
            default: {
                range = this.rangeZ;
                val = this.coord.func_177952_p();
                title = this.titleZ;
            }
        }
        if (range != null) {
            TableCellInteger cell = new TableCellInteger(null, val, range.min, range.max);
            cell.addPropertyConsumer(this.createConsumer(index));
            return new TitledCell(title, cell);
        }
        TableCellStringInt cell = new TableCellStringInt(null, val);
        cell.addPropertyConsumer(this.createConsumer(index));
        return new TitledCell(title, cell);
    }

    @Nonnull
    protected Consumer<Integer> createConsumer(int idx) {
        return property -> {
            this.coord = new BlockPos(idx == 0 ? property.intValue() : this.coord.func_177958_n(), idx == 1 ? property.intValue() : this.coord.func_177956_o(), idx == 2 ? property.intValue() : this.coord.func_177952_p());
            this.consumer.accept(this.coord);
        };
    }
}

