/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files;

import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import ivorius.reccomplex.utils.RawResourceLocation;
import ivorius.reccomplex.utils.leveled.LeveledBiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleLeveledRegistry<S>
implements LeveledRegistry<S> {
    protected LeveledBiMap<String, S> items = new LeveledBiMap(LeveledRegistry.Level.values().length);
    protected LeveledBiMap<String, Status> stati = new LeveledBiMap(this.items.levels());
    protected boolean activeCacheValid = false;
    protected Map<String, S> activeMap = new HashMap<String, S>();
    public String description;

    public SimpleLeveledRegistry(String description) {
        this.description = description;
    }

    public LeveledBiMap<String, S> contents() {
        return this.items;
    }

    public LeveledBiMap<String, Status> stati() {
        return this.stati;
    }

    public Map<String, S> map() {
        return Collections.unmodifiableMap(this.items.getMap());
    }

    public Map<String, S> map(LeveledRegistry.ILevel level) {
        return Collections.unmodifiableMap(this.items.getMap(level.getLevel()));
    }

    public Map<String, S> activeMap() {
        this.ensureActiveCache();
        return Collections.unmodifiableMap(this.activeMap);
    }

    public Collection<S> all() {
        return Collections.unmodifiableCollection(this.items.getMap().values());
    }

    public Collection<S> allActive() {
        this.ensureActiveCache();
        return Collections.unmodifiableCollection(this.activeMap.values());
    }

    @Nullable
    public S getActive(String id) {
        this.ensureActiveCache();
        return this.activeMap.get(id);
    }

    @Override
    @Nullable
    public S get(String id) {
        return (S)this.items.getMap().get((Object)id);
    }

    @Override
    public Status status(String id) {
        return (Status)this.stati.getMap().get((Object)id);
    }

    @Nonnull
    public Set<String> activeIDs() {
        this.ensureActiveCache();
        return Collections.unmodifiableSet(this.activeMap.keySet());
    }

    @Override
    @Nonnull
    public Set<String> ids() {
        return Collections.unmodifiableSet(this.items.getMap().keySet());
    }

    @Override
    public boolean has(String id) {
        return this.items.getMap().containsKey((Object)id);
    }

    public boolean hasActive(String id) {
        this.ensureActiveCache();
        return this.activeMap.containsKey(id);
    }

    public String id(S s) {
        return (String)this.items.getMap().inverse().get(s);
    }

    @Nullable
    public RawResourceLocation resourceLocation(S s) {
        String id = this.id(s);
        return id != null ? new RawResourceLocation(this.status((String)id).domain, id) : null;
    }

    @Override
    public S register(String id, String domain, S s, boolean active, LeveledRegistry.ILevel level) {
        this.invalidateActiveCache();
        this.stati.put(id, new Status(id, active, domain, level), level.getLevel());
        S old = this.items.put(id, s, level.getLevel());
        RecurrentComplex.logger.trace(String.format(old != null ? "Replaced %s '%s' at level %s" : "Registered %s '%s' at level %s", this.description, id, level));
        return old;
    }

    @Override
    public S unregister(String id, LeveledRegistry.ILevel level) {
        this.invalidateActiveCache();
        this.stati.remove(id, level.getLevel());
        return (S)this.items.remove(id, level.getLevel());
    }

    @Override
    public void clear(LeveledRegistry.ILevel level) {
        RecurrentComplex.logger.trace(String.format("Cleared all %s at level %s", this.description, level));
        this.invalidateActiveCache();
        this.items.clear(level.getLevel());
        this.stati.clear(level.getLevel());
    }

    private void ensureActiveCache() {
        if (!this.activeCacheValid) {
            this.activeMap = this.stati.getMap().values().stream().filter(LeveledRegistry.Status::isActive).map(LeveledRegistry.Status::getId).collect(Collectors.toMap(s -> s, s -> this.items.getMap().get(s)));
            this.activeCacheValid = true;
        }
    }

    private void invalidateActiveCache() {
        this.activeCacheValid = false;
    }

    public class Status
    implements LeveledRegistry.Status {
        protected String id;
        protected boolean active;
        protected String domain;
        protected LeveledRegistry.ILevel level;

        public Status(String id, boolean active, String domain, LeveledRegistry.ILevel level) {
            this.id = id;
            this.active = active;
            this.domain = domain;
            this.level = level;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public String getDomain() {
            return this.domain;
        }

        @Override
        public LeveledRegistry.ILevel getLevel() {
            return this.level;
        }

        @Override
        public void setActive(boolean active) {
            this.active = active;
            SimpleLeveledRegistry.this.invalidateActiveCache();
        }
    }
}

