/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.events.handlers;

import ivorius.ivtoolkit.rendering.grid.GridRenderer;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.Repository;
import ivorius.reccomplex.capability.CapabilitySelection;
import ivorius.reccomplex.capability.RCEntityInfo;
import ivorius.reccomplex.client.rendering.SelectionRenderer;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.events.ItemGenerationEvent;
import ivorius.reccomplex.item.ItemInputHandler;
import ivorius.reccomplex.world.gen.feature.WorldGenStructures;
import ivorius.reccomplex.world.gen.feature.WorldRandomData;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollection;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollectionRegistry;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class RCForgeEventHandler {
    public final Set<StructureBoundingBox> disabledTileDropAreas = new HashSet<StructureBoundingBox>();

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPreChunkDecoration(PopulateChunkEvent.Pre event) {
        WorldGenStructures.decorate((WorldServer)event.getWorld(), event.getRand(), new ChunkPos(event.getChunkX(), event.getChunkZ()), null);
    }

    @SubscribeEvent
    public void onEntityDrop(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityItem && this.disabledTileDropAreas.stream().anyMatch(input -> input.func_175898_b((Vec3i)new BlockPos(event.getEntity())))) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawWorld(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        int ticks = mc.field_71439_g.field_70173_aa;
        Entity renderEntity = mc.func_175606_aa();
        RCEntityInfo info = RCEntityInfo.get(mc.field_71439_g, null);
        double entityX = renderEntity.field_70142_S + (renderEntity.field_70165_t - renderEntity.field_70142_S) * (double)event.getPartialTicks();
        double entityY = renderEntity.field_70137_T + (renderEntity.field_70163_u - renderEntity.field_70137_T) * (double)event.getPartialTicks();
        double entityZ = renderEntity.field_70136_U + (renderEntity.field_70161_v - renderEntity.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-entityX), (double)(-entityY), (double)(-entityZ));
        if (info != null && info.showGrid) {
            int spacing = 10;
            GlStateManager.func_179090_x();
            GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(MathHelper.func_76128_c((double)(entityX / (double)spacing)) * spacing), (float)(MathHelper.func_76128_c((double)(entityY / (double)spacing)) * spacing), (float)(MathHelper.func_76128_c((double)(entityZ / (double)spacing)) * spacing));
            GridRenderer.renderGrid(8, spacing, 100.0f, 0.05f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
        }
        SelectionRenderer.renderSelection((EntityLivingBase)mc.field_71439_g, ticks, event.getPartialTicks());
        if (info != null && info.danglingOperation != null) {
            info.danglingOperation.renderPreview(info.getPreviewType(), (World)mc.field_71441_e, ticks, event.getPartialTicks());
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemInputHandler && ((ItemInputHandler)heldItem.func_77973_b()).onMouseInput((EntityPlayer)player, heldItem, event.getButton(), event.isButtonstate(), event.getDwheel())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemGeneration(ItemGenerationEvent event) {
        Pair<String, Float> pair = null;
        if (event instanceof ItemGenerationEvent.Artifact) {
            pair = RCConfig.customArtifactTag;
        } else if (event instanceof ItemGenerationEvent.Book) {
            pair = RCConfig.customBookTag;
        }
        if (pair != null && ((Float)pair.getRight()).floatValue() > 0.0f && event.random.nextFloat() < ((Float)pair.getRight()).floatValue()) {
            WeightedItemCollection weightedItemCollection = (WeightedItemCollection)WeightedItemCollectionRegistry.INSTANCE.get((String)pair.getLeft());
            if (weightedItemCollection != null) {
                event.inventory.func_70299_a(event.fromSlot, weightedItemCollection.getRandomItemStack(event.server, event.random));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        CapabilitySelection sel;
        RCEntityInfo sei = RCEntityInfo.get(event.player, null);
        if (sei != null) {
            sei.update((Entity)event.player);
        }
        if ((sel = CapabilitySelection.get((ICapabilityProvider)event.player, null)) != null) {
            sel.update((Entity)event.player);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if ((event.type == TickEvent.Type.CLIENT || event.type == TickEvent.Type.SERVER) && event.phase == TickEvent.Phase.END) {
            RecurrentComplex.communicationHandler.handleMessages(event.type == TickEvent.Type.SERVER, true);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event instanceof ConfigChangedEvent.OnConfigChangedEvent && event.getModID().equals("reccomplex")) {
            RCConfig.loadConfig(event.getConfigID());
            if (RecurrentComplex.config.hasChanged()) {
                RecurrentComplex.config.save();
            }
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        if (!RCConfig.canUseCommand(event.getCommand().func_71517_b(), event.getSender())) {
            event.setCanceled(true);
            TextComponentTranslation TextComponent = new TextComponentTranslation("commands.generic.permission", new Object[0]);
            TextComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            event.getSender().func_145747_a((ITextComponent)TextComponent);
        }
    }

    @SubscribeEvent
    public void onEntityCapapabilityAttach(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("reccomplex", "structureEntityInfo"), new SimpleCapabilityProvider<RCEntityInfo>(RCEntityInfo.CAPABILITY));
            event.addCapability(new ResourceLocation("reccomplex", "rc_selection"), new SimpleCapabilityProvider<CapabilitySelection>(CapabilitySelection.CAPABILITY));
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        WorldRandomData randomData;
        if (RCConfig.postWorldStatus && event.player.func_70003_b(3, "op") && (randomData = WorldRandomData.get(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_())).postWorldStatus(event.player.func_70005_c_())) {
            event.player.func_184102_h().field_71321_q.func_71556_a((ICommandSender)event.player, RCCommands.sanity.func_71517_b() + " --silent --short");
            TextComponentString count = new TextComponentString("" + StructureRegistry.INSTANCE.activeIDs().size());
            count.func_150256_b().func_150238_a(TextFormatting.AQUA);
            TextComponentString list = new TextComponentString("[List]");
            list.func_150256_b().func_150238_a(TextFormatting.AQUA);
            list.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Show List")));
            list.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/%s", RCCommands.list.func_71517_b())));
            TextComponentString add = new TextComponentString("[Add]");
            add.func_150256_b().func_150238_a(TextFormatting.GREEN);
            add.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Browse Repository")));
            add.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, Repository.browseURL()));
            TextComponentString remove = new TextComponentString("[Remove]");
            remove.func_150256_b().func_150238_a(TextFormatting.RED);
            remove.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Disabling Structures")));
            remove.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://minecraft-recurrent-complex.wikia.com/wiki/Disabling_Structures"));
            TextComponentString help = new TextComponentString("[Help]");
            help.func_150256_b().func_150238_a(TextFormatting.AQUA);
            help.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Open Wiki")));
            help.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://minecraft-recurrent-complex.wikia.com/wiki/Minecraft_Recurrent_Complex_Wiki"));
            ITextComponent statusMessage = RecurrentComplex.translations.format("reccomplex.server.status", count, list, add, remove, help);
            event.player.func_145747_a(statusMessage);
        }
    }

    private static class SimpleCapabilityProvider<T>
    implements ICapabilityProvider,
    INBTSerializable {
        public Capability<T> capability;
        public T t;

        public SimpleCapabilityProvider(Capability<T> capability) {
            this.capability = capability;
            this.t = capability.getDefaultInstance();
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == this.capability;
        }

        public <TI> TI getCapability(Capability<TI> capability, @Nullable EnumFacing facing) {
            return (TI)(capability == this.capability ? this.capability.cast(this.t) : null);
        }

        public NBTBase serializeNBT() {
            return this.capability.writeNBT(this.t, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            this.capability.readNBT(this.t, null, nbt);
        }
    }
}

