/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.structure;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.shadow.mcopts.translation.ServerTranslations;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.Metadata;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;

public class CommandSearchStructure
extends CommandExpecting {
    public static final int MAX_RESULTS = 20;

    @Nonnull
    public static Collection<String> keywords(String id, Structure<?> structure) {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.add(id);
        structure.generationTypes(GenerationType.class).forEach(info -> CommandSearchStructure.keywords((Collection<String>)keywords, info));
        if (structure instanceof GenericStructure) {
            CommandSearchStructure.keywords(keywords, ((GenericStructure)structure).metadata);
        }
        return keywords;
    }

    protected static void keywords(Collection<String> keywords, GenerationType info) {
        keywords.add(info.id());
        keywords.add(info.displayString());
        keywords.add(StructureRegistry.GENERATION_TYPES.iDForType(info.getClass()));
    }

    @Nonnull
    public static void keywords(Collection<String> collection, Metadata metadata) {
        collection.add(metadata.authors);
        collection.add(metadata.comment);
        collection.add(metadata.weblink);
    }

    public static float searchRank(List<String> query, Collection<String> keywords) {
        return keywords.stream().filter(arg_0 -> ((Predicate)Predicates.contains((Pattern)Pattern.compile(String.join((CharSequence)"|", Lists.transform(query, Pattern::quote)), 2))).apply(arg_0)).count();
    }

    public static <T> void postResultMessage(ICommandSender commandSender, Function<T, ? extends ITextComponent> toComponent, Queue<T> list) {
        if (list.size() > 0) {
            boolean cut = list.size() > 20;
            TextComponentBase[] components = new TextComponentBase[cut ? 20 : list.size()];
            for (int i = 0; i < components.length; ++i) {
                components[i] = cut && i == components.length - 1 ? new TextComponentString("... (" + list.size() + ")") : toComponent.apply(list.remove());
            }
            commandSender.func_145747_a((ITextComponent)ServerTranslations.join(components));
        } else {
            commandSender.func_145747_a(RecurrentComplex.translations.get("commands.rcsearch.empty"));
        }
    }

    @Nonnull
    public static <T> PriorityQueue<T> search(Set<T> omega, ToDoubleFunction<T> rank) {
        PriorityQueue strucs = new PriorityQueue(10, (o1, o2) -> Doubles.compare((double)rank.applyAsDouble(o1), (double)rank.applyAsDouble(o2)));
        strucs.addAll(omega.stream().filter(s -> rank.applyAsDouble(s) > 0.0).collect(Collectors.toList()));
        return strucs;
    }

    public String func_71517_b() {
        return RCConfig.commandPrefix + "search";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void expect(Expect expect) {
        expect.skip().descriptionU("terms").required().repeat();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        if (args.length < 1) {
            throw RecurrentComplex.translations.commandException("commands.rcsearch.usage", new Object[0]);
        }
        List<String> terms = parameters.get(0).varargsList().require();
        CommandSearchStructure.postResultMessage(commandSender, RCTextStyle::structure, CommandSearchStructure.search(StructureRegistry.INSTANCE.ids(), name -> CommandSearchStructure.searchRank(terms, CommandSearchStructure.keywords(name, (Structure)StructureRegistry.INSTANCE.get((String)name)))));
    }
}

