/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.structure;

import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.RCTextStyle;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.utils.RCStrings;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.generic.GenericStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.Metadata;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CommandLookupStructure
extends CommandExpecting {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "lookup";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void expect(Expect expect) {
        expect.then(RCE::structure);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        TextComponentString weblink;
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        String id = parameters.get(0).require();
        GenericStructure structure = (GenericStructure)parameters.get(0).to(p -> RCP.genericStructure(p, false)).require();
        Metadata metadata = structure.metadata;
        boolean hasWeblink = !metadata.weblink.trim().isEmpty();
        Object object = weblink = hasWeblink ? new TextComponentString(RCStrings.abbreviateFormatted(metadata.weblink, 30)) : RecurrentComplex.translations.format("commands.rclookup.reply.nolink", new Object[0]);
        if (hasWeblink) {
            weblink.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, metadata.weblink));
            weblink.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(metadata.weblink)));
        }
        TextComponentString level = new TextComponentString(StructureRegistry.INSTANCE.status(id).getLevel().toString());
        level.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        commandSender.func_145747_a(RecurrentComplex.translations.format(StructureRegistry.INSTANCE.hasActive(id) ? "commands.rclookup.reply.generates" : "commands.rclookup.reply.silent", id, RCTextStyle.users(metadata.authors), level, weblink));
        if (!metadata.comment.trim().isEmpty()) {
            commandSender.func_145747_a(RecurrentComplex.translations.format("commands.rclookup.reply.comment", metadata.comment));
        }
    }
}

