/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.former;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.world.MockWorld;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.capability.SelectionOwner;
import ivorius.reccomplex.commands.CommandVirtual;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.utils.RCBlockLogic;
import ivorius.reccomplex.utils.expression.PreloadedBooleanExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class CommandSelectFlood
extends CommandExpecting
implements CommandVirtual {
    public static final int MAX_FLOOD = 125000;

    public String func_71517_b() {
        return RCConfig.commandPrefix + "flood";
    }

    @Override
    public void expect(Expect expect) {
        expect.then(MCE::block).then(RCE::metadata).then(RCE::directionExpression);
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(MockWorld world, ICommandSender sender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        SelectionOwner selectionOwner = RCCommands.getSelectionOwner(sender, null, true);
        RCCommands.assertSize(sender, selectionOwner);
        PreloadedBooleanExpression facingExpression = PreloadedBooleanExpression.with(exp -> {
            exp.addConstants(EnumFacing.values());
            exp.addEvaluators(axis -> facing -> facing.func_176740_k() == axis, EnumFacing.Axis.values());
            exp.addEvaluator("horizontal", f -> f.func_176736_b() >= 0);
            exp.addEvaluator("vertical", f -> f.func_176736_b() < 0);
        });
        facingExpression.setExpression(parameters.get(2).rest(NaP::join).optional().orElse(""));
        List available = Arrays.stream(EnumFacing.values()).filter(facingExpression).collect(Collectors.toList());
        ArrayList dirty = Lists.newArrayList((Iterable)selectionOwner.getSelection());
        HashSet visited = Sets.newHashSet((Iterable)dirty);
        Block dstBlock = (Block)parameters.get(0).to(MCP.block(sender)).require();
        int[] dstMeta = parameters.get(1).to(RCP::metadatas).optional().orElse(new int[1]);
        List dst = IntStream.of(dstMeta).mapToObj(m -> BlockStates.fromMetadata(dstBlock, m)).collect(Collectors.toList());
        while (!dirty.isEmpty()) {
            BlockPos pos = (BlockPos)dirty.remove(dirty.size() - 1);
            for (EnumFacing facing : available) {
                BlockPos offset = pos.func_177972_a(facing);
                if (!RCBlockLogic.isAir(world, offset) || !visited.add(offset)) continue;
                dirty.add(offset);
            }
            if (visited.size() <= 125000) continue;
            throw new CommandException("Area too big to flood!", new Object[0]);
        }
        for (BlockPos pos : visited) {
            IBlockState state = (IBlockState)dst.get(world.rand().nextInt(dst.size()));
            world.setBlockState(pos, state, 2);
        }
    }
}

