/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.former;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockSurfaceArea;
import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.world.MockWorld;
import ivorius.reccomplex.block.BlockGenericSpace;
import ivorius.reccomplex.block.RCBlocks;
import ivorius.reccomplex.capability.SelectionOwner;
import ivorius.reccomplex.commands.CommandVirtual;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class CommandNaturalSpace
extends CommandExpecting
implements CommandVirtual {
    public static int sidesClosed(MockWorld world, BlockPos coord, BlockArea area) {
        int sides = 0;
        BlockPos lower = area.getLowerCorner();
        BlockPos higher = area.getHigherCorner();
        if (CommandNaturalSpace.sideClosed(world, new BlockPos(lower.func_177958_n(), coord.func_177956_o(), coord.func_177952_p()), coord.func_177958_n() - lower.func_177958_n(), 1, 0, 0)) {
            ++sides;
        }
        if (CommandNaturalSpace.sideClosed(world, new BlockPos(higher.func_177958_n(), coord.func_177956_o(), coord.func_177952_p()), higher.func_177958_n() - coord.func_177958_n(), -1, 0, 0)) {
            ++sides;
        }
        if (CommandNaturalSpace.sideClosed(world, new BlockPos(coord.func_177958_n(), coord.func_177956_o(), lower.func_177952_p()), coord.func_177952_p() - lower.func_177952_p(), 0, 0, 1)) {
            ++sides;
        }
        if (CommandNaturalSpace.sideClosed(world, new BlockPos(coord.func_177958_n(), coord.func_177956_o(), higher.func_177952_p()), higher.func_177952_p() - coord.func_177952_p(), 0, 0, -1)) {
            ++sides;
        }
        return sides;
    }

    public static boolean sideClosed(MockWorld world, BlockPos coord, int iterations, int xP, int yP, int zP) {
        for (int i = 0; i < iterations; ++i) {
            BlockPos pos = coord.func_177982_a(xP * i, yP * i, zP * i);
            IBlockState blockState = world.func_180495_p(pos);
            if (blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
            return true;
        }
        return false;
    }

    public static void placeNaturalAir(MockWorld world, BlockArea area, int floorDistance, int maxClosedSides) {
        BlockGenericSpace spaceBlock = RCBlocks.genericSpace;
        BlockPos lowerPoint = area.getLowerCorner();
        BlockPos higherPoint = area.getHigherCorner();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (BlockSurfacePos surfaceCoord : BlockSurfaceArea.from(area)) {
            IBlockState blockState;
            int y;
            int safePoint = lowerPoint.func_177956_o();
            for (y = higherPoint.func_177956_o(); y >= lowerPoint.func_177956_o(); --y) {
                blockState = world.func_180495_p(surfaceCoord.blockPos(y));
                if ((blockState.func_185904_a() == Material.field_151579_a || blockState.func_177230_c() == spaceBlock) && CommandNaturalSpace.sidesClosed(world, surfaceCoord.blockPos(y), area) < maxClosedSides) continue;
                boolean isFloor = blockState == RCBlocks.genericSolid.func_176223_P();
                safePoint = y + (isFloor ? 1 : floorDistance);
                break;
            }
            for (y = safePoint; y <= higherPoint.func_177956_o(); ++y) {
                set.add(surfaceCoord.blockPos(y));
            }
            if (safePoint > lowerPoint.func_177956_o()) {
                for (y = lowerPoint.func_177956_o(); y <= higherPoint.func_177956_o(); ++y) {
                    blockState = world.func_180495_p(surfaceCoord.blockPos(y));
                    if ((blockState.func_185904_a() == Material.field_151579_a || blockState.func_177230_c() == spaceBlock) && CommandNaturalSpace.sidesClosed(world, surfaceCoord.blockPos(y), area) < maxClosedSides) continue;
                    safePoint = y - 1;
                    break;
                }
            }
            for (y = lowerPoint.func_177956_o(); y <= safePoint; ++y) {
                set.add(surfaceCoord.blockPos(y));
            }
        }
        set.forEach(arg_0 -> CommandNaturalSpace.lambda$placeNaturalAir$184(world, lowerPoint, set, spaceBlock, arg_0));
    }

    public String func_71517_b() {
        return "space";
    }

    @Override
    public void expect(Expect expect) {
        expect.named("distance-to-floor", "d").any("3", "2", "1").named("max-closed-sides", "s").any("3", "4", "5");
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(MockWorld world, ICommandSender sender, String[] args) throws CommandException {
        SelectionOwner selectionOwner = RCCommands.getSelectionOwner(sender, null, true);
        RCCommands.assertSize(sender, selectionOwner);
        BlockArea area = selectionOwner.getSelection();
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        int floorDistance = parameters.get("distance-to-floor").to(NaP::asInt).optional().orElse(0) + 1;
        int maxClosedSides = parameters.get("max-closed-sides").to(NaP::asInt).optional().orElse(3);
        CommandNaturalSpace.placeNaturalAir(world, area, floorDistance, maxClosedSides);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$placeNaturalAir$184(MockWorld world, BlockPos lowerPoint, Set set, BlockGenericSpace spaceBlock, BlockPos pos) {
        down = pos.func_177977_b();
        down2 = pos.func_177979_c(2);
        if (pos.func_177956_o() <= lowerPoint.func_177956_o() || set.contains(down) || !world.func_180495_p(down).func_177230_c().func_176200_f((IBlockAccess)world, down) || !world.func_180495_p(down2).func_177230_c().func_176200_f((IBlockAccess)world, down2)) ** GOTO lbl-1000
        if (new BlockArea(pos.func_177973_b(new Vec3i(2, 0, 2)), pos.func_177971_a(new Vec3i(2, 0, 2))).stream().allMatch((Predicate<BlockPos>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Lnet/minecraft/util/math/BlockPos;)Z)((Set)set))) {
            v0 = spaceBlock.func_176223_P().func_177226_a((IProperty)BlockGenericSpace.TYPE, (Comparable)Integer.valueOf(1));
        } else lbl-1000:
        // 2 sources

        {
            v0 = spaceBlock.func_176223_P();
        }
        world.setBlockState(pos, v0);
    }
}

