/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.client;

import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RCProxy;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.block.RCBlocks;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.item.RCItems;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
implements RCProxy {
    public static final String[] VALID_MODIFIER_KEYS = new String[]{"ctrl", "lctrl", "rctrl", "shift", "lshift", "rshift"};

    @Override
    public File getDataDirectory() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public void loadConfig(String configID) {
        if (configID == null || configID.equals("visual")) {
            RCConfig.hideRedundantNegativeSpace = RecurrentComplex.config.getBoolean("hideRedundantNegativeSpace", "visual", true, "Only show the edges of negative space blocks? (Improves performance in big builds)");
        }
        if (configID == null || configID.equals("controls")) {
            RCConfig.blockSelectorModifierKeys = this.parseModifierKeys(RecurrentComplex.config.getString("blockSelectorModifierKeys", "controls", "ctrl", "The key to be held when you want to make a secondary selection with block selectors", VALID_MODIFIER_KEYS));
        }
    }

    private int[] parseModifierKeys(String key) {
        switch (key) {
            default: {
                return new int[]{29, 157};
            }
            case "lctrl": {
                return new int[]{29};
            }
            case "rctrl": {
                return new int[]{157};
            }
            case "shift": {
                return new int[]{42, 54};
            }
            case "lshift": {
                return new int[]{42};
            }
            case "rshift": 
        }
        return new int[]{54};
    }

    @Override
    public void registerRenderers() {
        if (!RecurrentComplex.isLite()) {
            this.registerItemsForDefaultRender(RCItems.blockSelector, RCItems.blockSelectorFloating);
            this.registerItemsForDefaultRender(RCItems.inventoryGenerationTag, RCItems.inventoryGenerationSingleTag, RCItems.inventoryGenerationComponentTag);
            this.registerItemsForDefaultRender(RCItems.artifactGenerationTag, RCItems.bookGenerationTag);
            this.registerItemsForDefaultRender(RCItems.inspector);
            this.registerTypeItemsForDefaultRender(RCBlocks.genericSpace, RCBlocks.genericSolid);
            this.registerItemsForDefaultRender(RCBlocks.structureGenerator, RCBlocks.mazeGenerator, RCBlocks.spawnCommands, RCBlocks.spawnScript);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        RCCommands.registerClientCommands(ClientCommandHandler.instance);
    }

    protected void registerTypeItemsForDefaultRender(Block ... blocks) {
        for (Block block : blocks) {
            this.registerTypeItemForDefaultRender(block);
        }
    }

    protected void registerItemsForDefaultRender(Block ... blocks) {
        for (Block block : blocks) {
            this.registerItemForDefaultRender(block);
        }
    }

    protected void registerItemsForDefaultRender(Item ... items) {
        for (Item item : items) {
            this.registerItemForDefaultRender(item);
        }
    }

    protected void registerItemForDefaultRender(Block block) {
        this.registerItemForDefaultRender(Item.func_150898_a((Block)block));
    }

    protected void registerTypeItemForDefaultRender(Block block) {
        Item item = Item.func_150898_a((Block)block);
        ResourceLocation id = RecurrentComplex.mcRegistry.idFromItem(item);
        for (int i = 0; i < 16; ++i) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, i, new ModelResourceLocation(String.format("%s_%d", id, i), "inventory"));
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(String.format("%s_%d", id, i))});
        }
    }

    protected void registerItemForDefaultRender(Item item) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation(RecurrentComplex.mcRegistry.idFromItem(item), "inventory"));
    }
}

