/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.runtime.providers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import minetweaker.runtime.IScriptIterator;

public class ScriptIteratorZip
implements IScriptIterator {
    private final File file;
    private final ZipFile zipFile;
    private final Iterator<ZipEntry> entries;
    private ZipEntry current;
    private final File directory;

    public ScriptIteratorZip(File file) throws IOException {
        this.file = file;
        this.directory = null;
        this.zipFile = new ZipFile(file);
        ArrayList<ZipEntry> entriesList = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> original = this.zipFile.entries();
        while (original.hasMoreElements()) {
            ZipEntry entry = original.nextElement();
            if (!entry.getName().endsWith(".zs")) continue;
            entriesList.add(entry);
        }
        this.entries = entriesList.iterator();
    }

    public ScriptIteratorZip(File file, File directory) throws IOException {
        this.file = file;
        this.directory = directory;
        this.zipFile = new ZipFile(file);
        ArrayList<ZipEntry> entriesList = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> original = this.zipFile.entries();
        while (original.hasMoreElements()) {
            ZipEntry entry = original.nextElement();
            if (!entry.getName().endsWith(".zs")) continue;
            entriesList.add(entry);
        }
        this.entries = entriesList.iterator();
    }

    @Override
    public String getGroupName() {
        if (this.file != null && this.directory != null) {
            return this.file.getAbsolutePath().substring(this.directory.getAbsolutePath().length() + 1);
        }
        return this.file.getName();
    }

    @Override
    public boolean next() {
        if (this.entries.hasNext()) {
            this.current = this.entries.next();
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.current == null || this.zipFile == null) {
            return "zzNullzz";
        }
        return this.current.getName().split("/")[this.current.getName().split("/").length - 1];
    }

    @Override
    public InputStream open() throws IOException {
        return this.zipFile.getInputStream(this.current);
    }
}

