/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1102.block;

import java.util.Collections;
import java.util.List;
import minetweaker.api.block.BlockPatternOr;
import minetweaker.api.block.IBlock;
import minetweaker.api.block.IBlockDefinition;
import minetweaker.api.block.IBlockPattern;
import minetweaker.api.data.IData;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MCWorldBlock
implements IBlock {
    private final IBlockAccess blocks;
    private final int x;
    private final int y;
    private final int z;
    private final BlockPos pos;

    public MCWorldBlock(IBlockAccess blocks, int x, int y, int z) {
        this.blocks = blocks;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pos = new BlockPos(x, y, z);
    }

    @Override
    public IBlockDefinition getDefinition() {
        return MineTweakerMC.getBlockDefinition(this.blocks.func_180495_p(this.pos).func_177230_c());
    }

    @Override
    public int getMeta() {
        return this.blocks.func_180495_p(this.pos).func_177230_c().func_176201_c(this.blocks.func_180495_p(this.pos));
    }

    @Override
    public IData getTileData() {
        TileEntity tileEntity = this.blocks.func_175625_s(this.pos);
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        tileEntity.func_189515_b(nbt);
        return MineTweakerMC.getIData((NBTBase)nbt);
    }

    @Override
    public String getDisplayName() {
        Block block = this.blocks.func_180495_p(this.pos).func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            return new ItemStack(item, 1, this.getMeta()).func_82833_r();
        }
        return block.func_149732_F();
    }

    @Override
    public List<IBlock> getBlocks() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean matches(IBlock block) {
        return this.getDefinition() == block.getDefinition() && (this.getMeta() == Short.MAX_VALUE || this.getMeta() == block.getMeta()) && (this.getTileData() == null || block.getTileData() != null && block.getTileData().contains(this.getTileData()));
    }

    @Override
    public IBlockPattern or(IBlockPattern pattern) {
        return new BlockPatternOr(this, pattern);
    }
}

