/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.tooltip;

import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.formatting.IFormattedText;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.util.IngredientMap;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="minetweaker.item.IIngredient")
public class IngredientTooltips {
    private static final IngredientMap<IFormattedText> TOOLTIPS = new IngredientMap();
    private static final IngredientMap<IFormattedText> SHIFT_TOOLTIPS = new IngredientMap();

    @ZenMethod
    public static void addTooltip(IIngredient ingredient, IFormattedText tooltip) {
        MineTweakerAPI.apply(new AddTooltipAction(ingredient, tooltip, false));
    }

    @ZenMethod
    public static void addShiftTooltip(IIngredient ingredient, IFormattedText tooltip) {
        MineTweakerAPI.apply(new AddTooltipAction(ingredient, tooltip, true));
    }

    public static List<IFormattedText> getTooltips(IItemStack item) {
        return TOOLTIPS.getEntries(item);
    }

    public static List<IFormattedText> getShiftTooltips(IItemStack item) {
        return SHIFT_TOOLTIPS.getEntries(item);
    }

    private static class AddTooltipAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final IFormattedText tooltip;
        private final boolean shift;
        private IngredientMap.IngredientMapEntry<IFormattedText> entry;

        public AddTooltipAction(IIngredient ingredient, IFormattedText tooltip, boolean shift) {
            this.ingredient = ingredient;
            this.tooltip = tooltip;
            this.shift = shift;
        }

        @Override
        public void apply() {
            this.entry = (this.shift ? SHIFT_TOOLTIPS : TOOLTIPS).register(this.ingredient, this.tooltip);
            MineTweakerAPI.getIjeiRecipeRegistry().invalidateTooltips(this.ingredient);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            if (this.shift) {
                SHIFT_TOOLTIPS.unregister(this.entry);
            } else {
                TOOLTIPS.unregister(this.entry);
            }
            MineTweakerAPI.getIjeiRecipeRegistry().invalidateTooltips(this.ingredient);
        }

        @Override
        public String describe() {
            return "Adding tooltip for " + this.ingredient + ": " + this.tooltip;
        }

        @Override
        public String describeUndo() {
            return "Removing tooltip for " + this.ingredient + ": " + this.tooltip;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

