/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.item;

import java.util.List;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientAny;
import minetweaker.api.item.IngredientOr;
import minetweaker.api.item.IngredientStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.player.IPlayer;
import minetweaker.util.ArrayUtil;

public class IngredientAnyAdvanced
implements IIngredient {
    private final String mark;
    private final IItemCondition[] conditions;
    private final IItemTransformer[] transformers;

    public IngredientAnyAdvanced(String mark, IItemCondition[] conditions, IItemTransformer[] transformers) {
        this.mark = mark;
        this.conditions = conditions;
        this.transformers = transformers;
    }

    @Override
    public String getMark() {
        return this.mark;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<IItemStack> getItems() {
        return null;
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return null;
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientAnyAdvanced(this.mark, this.conditions, ArrayUtil.append(this.transformers, transformer));
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientAnyAdvanced(this.mark, ArrayUtil.append(this.conditions, condition), this.transformers);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientAnyAdvanced(mark, this.conditions, this.transformers);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        for (IItemCondition condition : this.conditions) {
            if (condition.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        for (IItemCondition condition : this.conditions) {
            if (condition.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return true;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> iitems = ingredient.getItems();
        for (IItemStack iitem : iitems) {
            if (this.matches(iitem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        for (IItemTransformer transform : this.transformers) {
            item = transform.transform(item, byPlayer);
        }
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return this.transformers.length > 0;
    }

    @Override
    public Object getInternal() {
        return IngredientAny.INTERNAL_ANY;
    }
}

