/*
 * Decompiled with CFR 0.152.
 */
package lcrdrfs.entities;

import javax.annotation.Nullable;
import lcrdrfs.LCRDRFS;
import lcrdrfs.ai.FlyingMoveHelper;
import lcrdrfs.ai.PathNavigateFlying;
import lcrdrfs.confighandler.ConfigHandler;
import lcrdrfs.entities.EntityCreepssile;
import lcrdrfs.network.CreepssileLaunchMessage;
import lcrdrfs.network.JetPackFlightMessage;
import lcrdrfs.network.JetParticleMessage;
import lcrdrfs.network.KeyBindingHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityJetPackSpider
extends EntityCreature
implements IMob,
IInventory {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityJetPackSpider.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> STATE = EntityDataManager.func_187226_a(EntityJetPackSpider.class, (DataSerializer)DataSerializers.field_187191_a);
    private int explosionStrength = 1;
    public int launchCounter;
    public int talkCounter;
    public ItemStack[] inventory;
    public static final int AMMO_SLOT = 0;

    public EntityJetPackSpider(World world) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.field_70178_ae = true;
        this.field_70728_aV = 5;
        this.inventory = new ItemStack[1];
        this.field_70765_h = new FlyingMoveHelper(this);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WALKABLE, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72820_D() < (long)(ConfigHandler.JET_PACK_SPIDER_SPAWN_DELAY * 24000)) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.field_70170_p.func_72820_D() % 2L == 0L) {
            double leftJet = Math.toRadians(this.field_70761_aq - 50.0f);
            double rightJet = Math.toRadians(this.field_70761_aq + 50.0f);
            double heightY = this.field_70163_u;
            this.jetParticles((float)this.field_70165_t + (float)(-Math.sin(leftJet)) * -1.0f, (float)heightY, (float)this.field_70161_v + (float)Math.cos(leftJet) * -1.0f);
            this.jetParticles((float)this.field_70165_t + (float)(-Math.sin(rightJet)) * -1.0f, (float)heightY, (float)this.field_70161_v + (float)Math.cos(rightJet) * -1.0f);
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.getTameState() == 0) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1 && this.getTameState() == 0) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AICreepssileAttack(this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v)).func_177230_c() == Blocks.field_150355_j) {
            this.field_70181_x += 0.1;
        }
        if (!this.func_184207_aI() && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.5;
        }
        if (this.func_184207_aI() && this.field_70181_x < 0.0) {
            this.field_70181_x *= 1.0;
        }
        if (this.launchCounter < 30) {
            ++this.launchCounter;
        }
        if (this.talkCounter < 20) {
            ++this.talkCounter;
        }
        if (this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.32);
        }
    }

    private void jetParticles(float x, float y, float z) {
        for (EntityPlayer playersNear : this.field_70170_p.field_73010_i) {
            if (!(playersNear.func_70068_e((Entity)this) < 4096.0) || !(this.field_70181_x > 0.1)) continue;
            LCRDRFS.networkWrapper.sendToAll((IMessage)new JetParticleMessage(x, y, z));
        }
    }

    public boolean func_70097_a(DamageSource source, float damageAmount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, damageAmount);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
        this.field_70180_af.func_187214_a(STATE, (Object)0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateFlying((EntityLiving)this, worldIn);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.getTameState() == 0) {
            super.func_70612_e(strafe, forward);
        }
        if (this.getTameState() != 0 && this.func_184207_aI() && this.func_82171_bF()) {
            if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = player.field_70177_z;
                this.field_70125_A = player.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                if (!this.field_70122_E) {
                    strafe = player.field_70702_br;
                    forward = player.field_70701_bs;
                } else {
                    strafe = player.field_70702_br * 0.5f;
                    forward = player.field_70701_bs * 0.5f;
                }
                if (forward <= 0.0f) {
                    forward *= 0.1f;
                }
                this.field_70138_W = 2.0f;
                this.field_70747_aH = 0.2f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_70612_e(strafe, forward);
                } else if (this.func_184179_bs() instanceof EntityPlayer) {
                    this.field_70159_w = player.field_70159_w;
                    this.field_70181_x = player.field_70181_x;
                    this.field_70179_y = player.field_70179_y;
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d01 = this.field_70165_t - this.field_70169_q;
                double d11 = this.field_70161_v - this.field_70166_s;
                float f41 = MathHelper.func_76133_a((double)(d01 * d01 + d11 * d11)) * 4.0f;
                if (f41 > 1.0f) {
                    f41 = 1.0f;
                }
                this.field_70721_aZ += (f41 - this.field_70721_aZ) * 0.2f;
                this.field_184619_aG += this.field_70721_aZ;
                if (this.field_70170_p.field_72995_K) {
                    if (KeyBindingHandler.jetpackFlight.func_151470_d()) {
                        LCRDRFS.networkWrapper.sendToServer((IMessage)new JetPackFlightMessage(player, false, false));
                        this.field_70181_x += 0.1;
                    }
                    if (KeyBindingHandler.creepssileLaunch.func_151470_d() && this.launchCounter == 30) {
                        LCRDRFS.networkWrapper.sendToServer((IMessage)new CreepssileLaunchMessage(player));
                        this.launchCounter = 0;
                    }
                }
            } else {
                this.field_70138_W = 1.0f;
                this.field_70747_aH = 0.0f;
                super.func_70612_e(strafe, forward);
            }
        }
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityLivingBase;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean getHasAmmo(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() == LCRDRFS.CREEPSSILE_AMMO && this.func_70301_a((int)0).field_77994_a >= 2;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stack) {
        ItemStack is = player.field_71071_by.func_70448_g();
        float healingBuff = 0.0f;
        if (!this.field_70170_p.field_72995_K && is != null && is.func_77973_b() == LCRDRFS.CREEPER_CHILLI_CRYSTAL_SHARD) {
            if (this.getTameState() == 1) {
                healingBuff = 2.0f;
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(healingBuff);
                    player.func_184609_a(hand);
                    --is.field_77994_a;
                }
                if (this.func_110143_aJ() >= this.func_110138_aP() && this.talkCounter >= 20) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, LCRDRFS.DAMAGE_REPAIRED, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    this.talkCounter = 0;
                }
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && is == null && this.getTameState() == 1 && !player.func_70093_af()) {
            player.func_184220_m((Entity)this);
            return true;
        }
        if (!this.field_70170_p.field_72995_K && this.getTameState() == 1 && is != null && is.func_77973_b() == LCRDRFS.CREEPSSILE_AMMO || !this.field_70170_p.field_72995_K && player.func_70093_af()) {
            this.openGUI(player);
            return true;
        }
        return super.func_184645_a(player, hand, stack);
    }

    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (this.func_184179_bs() instanceof EntityLivingBase) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 0.4;
            double offSetZ = Math.cos(a) * 0.4;
            this.func_184179_bs().func_70107_b(this.field_70165_t - offSetX, this.field_70163_u + 0.6 + this.func_184179_bs().func_70033_W(), this.field_70161_v - offSetZ);
        }
    }

    protected SoundEvent func_184639_G() {
        int soundindex = this.field_70170_p.field_73012_v.nextInt(3);
        switch (soundindex) {
            case 0: {
                return LCRDRFS.JETPACK_SPIDER_IDLE1;
            }
            case 1: {
                return LCRDRFS.JETPACK_SPIDER_IDLE2;
            }
            case 2: {
                return LCRDRFS.JETPACK_SPIDER_IDLE3;
            }
        }
        return LCRDRFS.JETPACK_SPIDER_IDLE1;
    }

    protected SoundEvent func_184601_bQ() {
        return LCRDRFS.JETPACK_SPIDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return LCRDRFS.JETPACK_SPIDER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (this.field_70122_E) {
            this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
        }
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int bonus = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + looting);
        if (this.getTameState() == 0) {
            int count;
            for (count = 0; count < bonus; ++count) {
                this.func_145779_a(LCRDRFS.JETPACK_SPIDER_PART, 1);
            }
            bonus = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + looting);
            for (count = 0; count < bonus; ++count) {
                this.func_145779_a(LCRDRFS.CREEPER_CHILLI_CRYSTAL_SHARD, 1);
            }
            if (this.field_70170_p.field_73012_v.nextInt(50) == 0) {
                this.func_145779_a(LCRDRFS.CREEPSSILE_AMMO, 2);
            }
        }
        if (this.getTameState() != 0) {
            this.func_70099_a(new ItemStack(LCRDRFS.SPIDER_JETPACK, 1), 0.0f);
            if (this.func_70301_a(0) != null) {
                this.func_70099_a(new ItemStack(this.func_70301_a(0).func_77973_b(), this.func_70301_a((int)0).field_77994_a), 0.0f);
            }
        }
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public boolean func_70601_bi() {
        long spawnDelay;
        long worldTime = this.field_70170_p.func_72820_D();
        if (worldTime > (spawnDelay = (long)(ConfigHandler.JET_PACK_SPIDER_SPAWN_DELAY * 24000))) {
            BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
            if (blockpos.func_177956_o() <= this.field_70170_p.func_181545_F() + 32) {
                return false;
            }
            return this.func_70058_J() && super.func_70601_bi();
        }
        return false;
    }

    protected boolean func_70692_ba() {
        return this.getTameState() == 0;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_70692_ba();
    }

    public int func_70641_bl() {
        return 3;
    }

    public void setTameState(byte tameState) {
        this.field_70180_af.func_187227_b(STATE, (Object)tameState);
    }

    public byte getTameState() {
        return (Byte)this.field_70180_af.func_187225_a(STATE);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("tameState", this.getTameState());
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(data);
            tags.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Items", (NBTBase)tags);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTameState(nbt.func_74771_c("tameState"));
        NBTTagList tags = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound data = tags.func_150305_b(i);
            int j = data.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
    }

    public void openGUI(EntityPlayer player) {
        if (!(this.field_70170_p.field_72995_K || this.func_184179_bs() != null && this.func_184179_bs() != player || this.getTameState() == 0)) {
            player.openGui((Object)LCRDRFS.instance, 1, player.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= size) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(size);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    static class AICreepssileAttack
    extends EntityAIBase {
        private final EntityJetPackSpider parentEntity;
        public int attackTimer;

        public AICreepssileAttack(EntityJetPackSpider spider) {
            this.parentEntity = spider;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (!this.parentEntity.field_70170_p.field_72995_K) {
                double d0 = 64.0;
                World world = this.parentEntity.field_70170_p;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 576.0 && entitylivingbase.func_70068_e((Entity)this.parentEntity) > 64.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                    double targetZ;
                    double targetY;
                    double targetX;
                    ++this.attackTimer;
                    if (this.attackTimer == 10) {
                        world.func_184148_a((EntityPlayer)null, this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v, LCRDRFS.JETPACK_SPIDER_TARGET, SoundCategory.HOSTILE, 2.0f, 1.0f);
                    }
                    if (this.attackTimer == 20) {
                        EntityCreepssile missile1 = new EntityCreepssile(world, (EntityLivingBase)this.parentEntity, ConfigHandler.CREEPSSILE_DAMAGE, 0);
                        targetX = entitylivingbase.field_70165_t + entitylivingbase.field_70159_w - this.parentEntity.field_70165_t;
                        targetY = entitylivingbase.field_70163_u - this.parentEntity.field_70163_u + 1.0;
                        targetZ = entitylivingbase.field_70161_v + entitylivingbase.field_70179_y - this.parentEntity.field_70161_v;
                        missile1.func_70186_c(targetX, targetY, targetZ, 1.0f, 0.0f);
                        double directionLeft = Math.toRadians(this.parentEntity.field_70761_aq - 30.0f);
                        missile1.func_70107_b(this.parentEntity.field_70165_t + -Math.sin(directionLeft) * 0.8, this.parentEntity.field_70163_u + 0.4, this.parentEntity.field_70161_v + Math.cos(directionLeft) * 0.8);
                        world.func_72838_d((Entity)missile1);
                        world.func_184148_a((EntityPlayer)null, this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v, LCRDRFS.CREEPSSILE_LAUNCH, SoundCategory.HOSTILE, 2.0f, 1.0f);
                    }
                    if (this.attackTimer == 30) {
                        EntityCreepssile missile2 = new EntityCreepssile(world, (EntityLivingBase)this.parentEntity, ConfigHandler.CREEPSSILE_DAMAGE, 0);
                        targetX = entitylivingbase.field_70165_t + entitylivingbase.field_70159_w - this.parentEntity.field_70165_t;
                        targetY = entitylivingbase.field_70163_u - this.parentEntity.field_70163_u + 1.0;
                        targetZ = entitylivingbase.field_70161_v + entitylivingbase.field_70179_y - this.parentEntity.field_70161_v;
                        missile2.func_70186_c(targetX, targetY, targetZ, 1.0f, 0.0f);
                        double directionRight = Math.toRadians(this.parentEntity.field_70761_aq + 30.0f);
                        missile2.func_70107_b(this.parentEntity.field_70165_t + -Math.sin(directionRight) * 0.8, this.parentEntity.field_70163_u + 0.4, this.parentEntity.field_70161_v + Math.cos(directionRight) * 0.8);
                        world.func_72838_d((Entity)missile2);
                        world.func_184148_a((EntityPlayer)null, this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v, LCRDRFS.CREEPSSILE_LAUNCH, SoundCategory.HOSTILE, 2.0f, 1.0f);
                        this.attackTimer = -40;
                    }
                } else if (this.attackTimer > 0) {
                    --this.attackTimer;
                }
                this.parentEntity.setAttacking(this.attackTimer > 10);
            }
        }
    }
}

