/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.minesouls.playerHandler;

import com.rwtema.minesouls.Helper;
import com.rwtema.minesouls.config.DifficultyConfig;
import com.rwtema.minesouls.network.MessagePlayerHandlerStats;
import com.rwtema.minesouls.network.NetworkHandler;
import com.rwtema.minesouls.playerHandler.PlayerHandlerRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerHandler
implements INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    public static final UUID dodgeID = UUID.fromString("c0dc01c8-8a4a-4ad4-af9f-2d83da0c8d6f");
    public final EntityPlayer player;
    public int enduranceCooldown = 0;
    public float poise = 0.0f;
    public int poiseCooldown = 0;
    public float endurance = DifficultyConfig.MAX_ENDURANCE;
    public int staggeredTimer = 0;
    public int dodgeTimer = 0;
    public float dodgeF = 0.0f;
    public float dodgeS = 0.0f;
    public float dodgeY = 0.0f;
    public float dodgeP = 0.0f;
    boolean dirty = false;
    boolean wasPressingLeftClick;

    public PlayerHandler(EntityPlayer player) {
        this.player = player;
    }

    public void onJump() {
        this.endurance -= DifficultyConfig.ENDURANCE_COST_PER_JUMP;
        this.enduranceCooldown = (int)Math.max((float)this.enduranceCooldown, DifficultyConfig.ENDURANCE_COST_PER_JUMP / DifficultyConfig.ENDURANCE_COOLDOWN_ACTION_MODIFIER);
        this.dirty = true;
        this.checkEndurance();
    }

    public void attackPrevent(AttackEntityEvent event) {
        if (this.dodgeTimer > 0 || this.staggeredTimer > 0 || this.player.func_184825_o(1.0f) != 1.0f || this.endurance < DifficultyConfig.ENDURANCE_COST_PER_ATTACK || this.enduranceCooldown > 0) {
            event.setCanceled(true);
        } else {
            this.endurance -= DifficultyConfig.ENDURANCE_COST_PER_ATTACK;
            this.enduranceCooldown = (int)Math.max((float)this.enduranceCooldown, DifficultyConfig.ENDURANCE_COST_PER_ATTACK / DifficultyConfig.ENDURANCE_COOLDOWN_ACTION_MODIFIER);
            this.dirty = true;
            this.checkEndurance();
        }
    }

    public void tick() {
        if (this.player.func_110143_aJ() <= 0.0f) {
            this.poise = 0.0f;
            this.endurance = 0.0f;
            this.staggeredTimer = 0;
            this.poiseCooldown = 0;
            this.enduranceCooldown = 0;
            this.dodgeTimer = 0;
            return;
        }
        if (this.poiseCooldown > 0) {
            --this.poiseCooldown;
            if (this.poiseCooldown == 0) {
                this.poise = 0.0f;
                this.dirty = true;
            }
        }
        if (this.staggeredTimer > 0) {
            this.player.func_184821_cY();
            this.player.func_70031_b(false);
            --this.staggeredTimer;
            if (this.staggeredTimer == 0) {
                this.dirty = true;
            }
        }
        if (this.dodgeTimer > 0) {
            --this.dodgeTimer;
        }
        if (this.endurance <= 0.0f) {
            this.player.func_70031_b(false);
        }
        if (this.enduranceCooldown > 0) {
            --this.enduranceCooldown;
            if (this.enduranceCooldown <= 0) {
                this.enduranceCooldown = 0;
                this.endurance = Math.max(this.endurance, DifficultyConfig.ENDURANCE_REGAIN_FROM_ZERO);
            }
        } else if (this.player.func_70051_ag()) {
            if (this.endurance > 0.0f) {
                this.dirty = true;
            }
            this.endurance -= DifficultyConfig.ENDURANCE_LOSS_SPRINTING;
        } else {
            if (this.endurance < (float)DifficultyConfig.MAX_ENDURANCE) {
                this.dirty = true;
            }
            this.endurance = this.player.func_184585_cz() || this.player.func_71024_bL().func_75116_a() < 6 ? (this.endurance += DifficultyConfig.ENDURANCE_GAIN_REDUCED) : (this.endurance += DifficultyConfig.ENDURANCE_GAIN_REGULAR);
        }
        this.checkDodgeSpeed();
        this.checkEndurance();
    }

    private void checkEndurance() {
        if (this.endurance <= 0.0f) {
            this.endurance = 0.0f;
            if (this.enduranceCooldown == 0) {
                this.enduranceCooldown = Math.max(this.enduranceCooldown, DifficultyConfig.EMPTY_ENDURANCE_COOLDOWN);
            }
            this.player.func_70031_b(false);
        } else if (this.endurance > (float)DifficultyConfig.MAX_ENDURANCE) {
            this.endurance = DifficultyConfig.MAX_ENDURANCE;
        }
        if (this.dirty) {
            if (this.player instanceof EntityPlayerMP) {
                NetworkHandler.network.sendTo((IMessage)new MessagePlayerHandlerStats(this), (EntityPlayerMP)this.player);
            }
            this.dirty = false;
        }
    }

    public void attacked(LivingAttackEvent event) {
        if (this.dodgeTimer > 0 && !event.getSource().func_76363_c()) {
            event.setCanceled(true);
        }
    }

    public void hurt(LivingHurtEvent event) {
        ItemStack stack;
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        if (amount > 32768.0f) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        if (this.endurance == 0.0f) {
            amount *= DifficultyConfig.NO_ENDURANCE_DAMAGE_MODIFIER;
        }
        if (this.staggeredTimer > 0) {
            amount *= DifficultyConfig.STAGGER_DAMAGE_MODIFIER;
        }
        if (this.endurance > 0.0f && this.staggeredTimer == 0 && !source.func_76363_c() && this.player.func_184585_cz()) {
            float block = this.endurance / DifficultyConfig.BLOCKING_ENDURANCE_MODIFIER;
            if (block > amount) {
                this.endurance -= amount * DifficultyConfig.BLOCKING_ENDURANCE_MODIFIER;
                amount = 0.0f;
            } else {
                amount -= block;
                this.endurance = 0.0f;
            }
        }
        if (this.staggeredTimer == 0 && amount > 0.0f) {
            this.poiseCooldown = DifficultyConfig.POISE_COOLDOWN;
            float poiseToAdd = amount;
            poiseToAdd *= DifficultyConfig.POISE_LOSS_BASE_MODIFIER;
            if (this.player.func_70093_af()) {
                poiseToAdd *= DifficultyConfig.POISE_PROTECTION_SNEAK_MODIFIER;
            }
            if (!source.func_76363_c()) {
                Entity entity = source.func_76346_g();
                if (source.func_76364_f() != null) {
                    if (entity != source.func_76364_f()) {
                        poiseToAdd *= DifficultyConfig.POISE_LOSS_PROJECTILE_MODIFIER;
                    }
                    entity = source.func_76364_f();
                }
                if (entity instanceof EntityLivingBase) {
                    ItemStack stack2 = ((EntityLivingBase)entity).func_184614_ca();
                    if (stack2 == null) {
                        poiseToAdd *= DifficultyConfig.POISE_LOSS_BARE_HAND_MODIFIER;
                    } else if (Helper.isItemOfType(stack2, Helper.ToolType.TOOL)) {
                        poiseToAdd *= DifficultyConfig.POISE_LOSS_ANY_TOOL_MODIFIER;
                        if (Helper.isSword(stack2)) {
                            poiseToAdd *= DifficultyConfig.POISE_LOSS_SWORD_MODIFIER;
                        }
                        if (Helper.isItemOfType(stack2, Helper.ToolType.AXE)) {
                            poiseToAdd *= DifficultyConfig.POISE_LOSS_AXE_MODIFIER;
                        }
                        if (Helper.isItemOfType(stack2, Helper.ToolType.PICKAXE)) {
                            poiseToAdd *= DifficultyConfig.POISE_LOSS_PICKAXE_MODIFIER;
                        }
                        if (Helper.isItemOfType(stack2, Helper.ToolType.SHOVEL)) {
                            poiseToAdd *= DifficultyConfig.POISE_LOSS_SHOVEL_MODIFIER;
                        }
                        if (Helper.isItemOfType(stack2, Helper.ToolType.HEAVYTOOL)) {
                            poiseToAdd *= DifficultyConfig.POISE_LOSS_LARGE_TOOL_MODIFIER;
                        }
                    }
                }
            }
            this.poise += poiseToAdd;
            float poiseBreakPoint = this.getPoiseBreakPoint();
            if (this.poise > poiseBreakPoint) {
                this.staggeredTimer = Math.min(10 + (int)Math.ceil(4.0f * (this.poise - poiseBreakPoint)), DifficultyConfig.STAGGER_TIME);
                this.poise = poiseBreakPoint;
            }
        }
        if (this.staggeredTimer == 0 && amount > 0.0f && !source.func_76363_c() && this.player.func_184587_cr() && (stack = this.player.func_184607_cu()) != null && stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT) {
            this.player.func_184602_cy();
        }
        this.dirty = true;
        this.checkEndurance();
        event.setAmount(amount);
    }

    public float getPoiseBreakPoint() {
        return (float)ForgeHooks.getTotalArmorValue((EntityPlayer)this.player) * DifficultyConfig.POISE_ARMOR_MODIFIER;
    }

    @SideOnly(value=Side.CLIENT)
    public void clientTick() {
        Entity entity;
        Minecraft mc = Minecraft.func_71410_x();
        boolean pressingLeftClick = mc.field_71474_y.field_74312_F.func_151470_d();
        if (Helper.isSword(this.player.func_184614_ca()) && this.player.func_184825_o(1.0f) == 1.0f && pressingLeftClick && this.wasPressingLeftClick && (entity = mc.field_147125_j) != null && mc.field_71442_b != null) {
            mc.field_71442_b.func_78764_a(this.player, entity);
            this.player.func_184609_a(EnumHand.MAIN_HAND);
        }
        this.wasPressingLeftClick = pressingLeftClick;
        this.checkDodgeSpeed();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("enduranceCooldown", this.enduranceCooldown);
        nbt.func_74768_a("poiseCooldown", this.poiseCooldown);
        nbt.func_74776_a("endurance", this.endurance);
        nbt.func_74776_a("poise", this.poise);
        nbt.func_74768_a("staggeredTimer", this.staggeredTimer);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.enduranceCooldown = nbt.func_74762_e("enduranceCooldown");
        this.poiseCooldown = nbt.func_74762_e("poiseCooldown");
        this.staggeredTimer = nbt.func_74762_e("staggeredTimer");
        this.poise = nbt.func_74760_g("poise");
        this.endurance = nbt.func_74760_g("endurance");
        this.dirty = true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == PlayerHandlerRegistry.capability;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == PlayerHandlerRegistry.capability ? PlayerHandlerRegistry.capability.cast((Object)this) : null);
    }

    public void startDodge() {
        this.dodgeTimer = DifficultyConfig.DODGE_TIME;
        this.endurance -= (float)DifficultyConfig.ENDURANCE_COST_PER_DODGE;
        this.enduranceCooldown = (int)Math.max((float)this.enduranceCooldown, (float)DifficultyConfig.ENDURANCE_COST_PER_DODGE / DifficultyConfig.ENDURANCE_COOLDOWN_ACTION_MODIFIER);
        this.dirty = true;
        this.checkDodgeSpeed();
        this.checkEndurance();
    }

    public void checkDodgeSpeed() {
        IAttributeInstance instance = this.player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        AttributeModifier modifier = instance.func_111127_a(dodgeID);
        if (this.dodgeTimer <= 0) {
            if (modifier != null) {
                instance.func_111124_b(modifier);
            }
        } else if (modifier == null) {
            instance.func_111121_a(new AttributeModifier(dodgeID, "dodge", (double)(DifficultyConfig.DODGE_SPEED - 1.0f), 2));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTick() {
        if (this.dodgeTimer > 0) {
            this.player.field_70177_z = this.player.field_70126_B = this.dodgeY;
        }
    }
}

