/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.minesouls.network;

import com.rwtema.minesouls.MineSouls;
import com.rwtema.minesouls.network.MessageDodgeStart;
import com.rwtema.minesouls.network.MessagePlayerHandlerStats;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkHandler {
    public static final SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel("minesouls");
    public static final IMessageHandler<Message, Message> handler = new Handler();

    public static void init() {
        network.registerMessage(handler, MessagePlayerHandlerStats.class, 0, Side.CLIENT);
        network.registerMessage(handler, MessageDodgeStart.class, 1, Side.SERVER);
    }

    public static abstract class Message
    implements IMessage {
        PacketBuffer buffer;

        public void fromBytes(ByteBuf buf) {
            this.buffer = new PacketBuffer(buf);
            this.readData(this.buffer);
        }

        public abstract void readData(PacketBuffer var1);

        public void toBytes(ByteBuf buf) {
            this.writeData(new PacketBuffer(buf));
        }

        protected abstract void writeData(PacketBuffer var1);

        public Message runServer(MessageContext ctx) {
            throw new IllegalStateException("Unexpected Side");
        }

        @SideOnly(value=Side.CLIENT)
        public Message runClient(MessageContext ctx) {
            throw new IllegalStateException("Unexpected Side");
        }
    }

    public static class Handler
    implements IMessageHandler<Message, Message> {
        public Message onMessage(Message message, MessageContext ctx) {
            return MineSouls.proxy.runMessage(message, ctx);
        }
    }
}

