/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.minesouls.hud;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.rwtema.minesouls.MineSouls;
import com.rwtema.minesouls.config.DifficultyConfig;
import com.rwtema.minesouls.config.PersonalConfig;
import com.rwtema.minesouls.gui.GuiYouDied;
import com.rwtema.minesouls.playerHandler.PlayerHandler;
import com.rwtema.minesouls.playerHandler.PlayerHandlerRegistry;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HUDHandler {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("minesouls", "textures/gui.png");
    public final int BORDER = 12;
    float partialTime = 0.0f;
    float intensity = 0.0f;
    List<ScrollBar> scrollBars = ImmutableList.builder().add((Object)new ScrollBar(20, RenderGameOverlayEvent.ElementType.HEALTH, 0.0f, 0.0f, 0.9f){

        @Override
        public float getCurrentValue(EntityPlayer player, PlayerHandler handler) {
            return player.func_110143_aJ() + player.func_110139_bj();
        }

        @Override
        public float getMaxValue(EntityPlayer player, PlayerHandler handler) {
            return player.func_110138_aP() + player.func_110139_bj();
        }

        @Override
        protected boolean isEmergency(EntityPlayerSP thePlayer, PlayerHandler handler) {
            return thePlayer.func_110143_aJ() < thePlayer.func_110138_aP() / 5.0f;
        }
    }).add((Object)new ScrollBar(DifficultyConfig.MAX_ENDURANCE, null, 0.9f, 0.0f, 0.0f){

        @Override
        public float getCurrentValue(EntityPlayer player, PlayerHandler handler) {
            return handler.endurance;
        }

        @Override
        protected boolean isEmergency(EntityPlayerSP thePlayer, PlayerHandler handler) {
            return handler.endurance == 0.0f || handler.staggeredTimer > 0;
        }

        @Override
        public boolean shouldRender(EntityPlayer player, PlayerHandler handler) {
            return MineSouls.isMineSoulsOnServer();
        }
    }).add((Object)new ScrollBar(20, RenderGameOverlayEvent.ElementType.FOOD, 0.4117647f, 0.0f, 0.9f){

        @Override
        public float getCurrentValue(EntityPlayer player, PlayerHandler handler) {
            if (player.func_110143_aJ() <= 0.0f) {
                return 0.0f;
            }
            FoodStats stats = player.func_71024_bL();
            return stats.func_75116_a();
        }

        @Override
        protected boolean isEmergency(EntityPlayerSP thePlayer, PlayerHandler handler) {
            return this.getCurrentValue((EntityPlayer)thePlayer, handler) <= 6.0f;
        }
    }).add((Object)new ScrollBar(25, RenderGameOverlayEvent.ElementType.ARMOR, 0.90588236f, 0.9411765f, 0.9019608f){

        @Override
        public float getCurrentValue(EntityPlayer player, PlayerHandler handler) {
            if (player.func_110143_aJ() <= 0.0f) {
                return 0.0f;
            }
            if (!MineSouls.isMineSoulsOnServer()) {
                return this.getMaxValue(player, handler);
            }
            if (handler.staggeredTimer > 0) {
                return 0.0f;
            }
            float poiseLevel = handler.poise / handler.getPoiseBreakPoint();
            return (1.0f - poiseLevel) * this.getMaxValue(player, handler);
        }

        @Override
        public float getMaxValue(EntityPlayer player, PlayerHandler handler) {
            return ForgeHooks.getTotalArmorValue((EntityPlayer)player);
        }

        @Override
        public boolean shouldRender(EntityPlayer player, PlayerHandler handler) {
            return ForgeHooks.getTotalArmorValue((EntityPlayer)player) > 0;
        }

        @Override
        protected boolean isEmergency(EntityPlayerSP thePlayer, PlayerHandler handler) {
            return thePlayer.func_110143_aJ() <= 0.0f || MineSouls.isMineSoulsOnServer() && (handler.staggeredTimer > 0 || handler.poise >= handler.getPoiseBreakPoint());
        }
    }).add((Object)new ScrollBar(20, RenderGameOverlayEvent.ElementType.HEALTHMOUNT, 0.0f, 0.0f, 1.0f){

        @Override
        public float getCurrentValue(EntityPlayer player, PlayerHandler handler) {
            Entity tmp = player.func_184187_bx();
            if (!(tmp instanceof EntityLivingBase)) {
                return 20.0f;
            }
            return ((EntityLivingBase)tmp).func_110143_aJ();
        }

        @Override
        public float getMaxValue(EntityPlayer player, PlayerHandler handler) {
            Entity tmp = player.func_184187_bx();
            if (!(tmp instanceof EntityLivingBase)) {
                return 20.0f;
            }
            return ((EntityLivingBase)tmp).func_110138_aP();
        }

        @Override
        public boolean shouldRender(EntityPlayer player, PlayerHandler handler) {
            return player.func_184187_bx() instanceof EntityLivingBase;
        }

        @Override
        protected boolean isEmergency(EntityPlayerSP thePlayer, PlayerHandler handler) {
            Entity tmp = thePlayer.func_184187_bx();
            return tmp instanceof EntityLivingBase && ((EntityLivingBase)tmp).field_70172_ad > 0;
        }
    }).add((Object)new ScrollBar(300, RenderGameOverlayEvent.ElementType.AIR, 0.0f, 1.0f, 0.0f){

        @Override
        public float getCurrentValue(EntityPlayer player, PlayerHandler handler) {
            return Math.max(0, player.func_70086_ai());
        }

        @Override
        public boolean shouldRender(EntityPlayer player, PlayerHandler handler) {
            return player.func_70055_a(Material.field_151586_h);
        }

        @Override
        protected boolean isEmergency(EntityPlayerSP thePlayer, PlayerHandler handler) {
            return thePlayer.func_70086_ai() <= 0;
        }
    }).build();
    Set<RenderGameOverlayEvent.ElementType> preventDrawing;
    int time = 0;
    private int cur_armor_height = 0;

    public HUDHandler() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE);
        for (ScrollBar scrollBar : this.scrollBars) {
            if (scrollBar.type == null) continue;
            builder.add((Object)scrollBar.type);
        }
        this.preventDrawing = builder.build();
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new HUDHandler());
    }

    @SubscribeEvent
    public void guiOverride(GuiOpenEvent event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiGameOver) {
            event.setGui((GuiScreen)new GuiYouDied(((GuiGameOver)gui).field_184871_f));
        }
    }

    @SubscribeEvent
    public void renderPartial(TickEvent.RenderTickEvent event) {
        this.partialTime = event.renderTickTime;
        this.intensity = (float)(2.0 + Math.cos((double)(((float)this.time + this.partialTime) / 19.0f) * Math.PI)) / 3.0f;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        ++this.time;
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.clientTick();
        }
    }

    @SubscribeEvent
    public void preventDrawingVanillaBars(RenderGameOverlayEvent.Pre event) {
        if (PersonalConfig.OLD_SCHOOL_GUI) {
            return;
        }
        if (this.preventDrawing.contains(event.getType())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void hudDraw(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP thePlayer = mc.field_71439_g;
        if (thePlayer == null || thePlayer.field_71075_bZ.field_75098_d) {
            return;
        }
        GuiIngameForge hud = (GuiIngameForge)mc.field_71456_v;
        if (PersonalConfig.OLD_SCHOOL_GUI) {
            if (!MineSouls.isMineSoulsOnServer()) {
                return;
            }
            this.renderEndurance(mc, hud, thePlayer);
        } else {
            boolean guiLeftSide = true;
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)PersonalConfig.GUI_SCALE, (float)PersonalConfig.GUI_SCALE, (float)1.0f);
            this.renderExperience(mc, thePlayer, hud, 12, 12);
            mc.func_110434_K().func_110577_a(GUI_TEXTURE);
            int x = 37;
            int y = 13;
            for (ScrollBar scrollBar : this.scrollBars) {
                if (!scrollBar.shouldRender) continue;
                scrollBar.render(hud, x, y);
                y += scrollBar.TEX_HEIGHT + 1;
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        }
    }

    @SubscribeEvent
    public void armorDrawPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR) {
            this.cur_armor_height = GuiIngameForge.left_height;
        }
    }

    @SubscribeEvent
    public void armorDrawPos(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ARMOR && PersonalConfig.OLD_SCHOOL_GUI && MineSouls.isMineSoulsOnServer()) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = new ScaledResolution(mc);
            GlStateManager.func_179147_l();
            int left = res.func_78326_a() / 2 - 91;
            int top = res.func_78328_b() - this.cur_armor_height;
            mc.func_110434_K().func_110577_a(GUI_TEXTURE);
            PlayerHandler handler = PlayerHandlerRegistry.INSTANCE.getPlayerHandler((EntityPlayer)mc.field_71439_g);
            float poiseLevel = handler.poise / handler.getPoiseBreakPoint();
            int level = Math.round((float)ForgeHooks.getTotalArmorValue((EntityPlayer)mc.field_71439_g) * poiseLevel);
            int offset = handler.staggeredTimer > 0 ? 18 : 0;
            for (int i = 1; level > 0 && i < 20; i += 2) {
                GuiIngame hud = mc.field_71456_v;
                if (i < level) {
                    hud.func_73729_b(left, top, offset + 9, 30, 9, 9);
                } else if (i == level) {
                    hud.func_73729_b(left, top, offset, 30, 9, 9);
                }
                left += 8;
            }
            GlStateManager.func_179084_k();
            mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        }
    }

    private void renderEndurance(Minecraft mc, GuiIngameForge hud, EntityPlayerSP thePlayer) {
        mc.func_110434_K().func_110577_a(GUI_TEXTURE);
        ScaledResolution resolution = new ScaledResolution(mc);
        GlStateManager.func_179147_l();
        int left = resolution.func_78326_a() / 2 + 91;
        int top = resolution.func_78328_b() - GuiIngameForge.right_height;
        GuiIngameForge.right_height += 10;
        PlayerHandler handler = PlayerHandlerRegistry.INSTANCE.getPlayerHandler((EntityPlayer)thePlayer);
        int level = Math.round(handler.endurance / (float)DifficultyConfig.MAX_ENDURANCE * 20.0f);
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - (9 - i) * 8 - 9;
            int y = top + 1;
            if (idx < level) {
                hud.func_73729_b(x, y, 8, 23, 8, 7);
                continue;
            }
            if (idx == level) {
                hud.func_73729_b(x, y, 16, 23, 8, 7);
                continue;
            }
            hud.func_73729_b(x, y, 0, 23, 8, 7);
        }
        GlStateManager.func_179084_k();
    }

    public void renderExperience(Minecraft mc, EntityPlayerSP thePlayer, GuiIngameForge hud, int base_x, int base_y) {
        mc.func_110434_K().func_110577_a(GUI_TEXTURE);
        hud.func_73729_b(base_x, base_y, 0, 0, 23, 23);
        float t = thePlayer.field_71106_cc;
        if (t > 0.0f) {
            double ady;
            if (t > 1.0f) {
                t = 1.0f;
            }
            double angle = 1.5707963267948966 + (double)t * Math.PI * 2.0;
            double dx = (float)Math.cos(angle);
            double dy = (float)Math.sin(angle);
            double adx = Math.abs(dx);
            if (adx < (ady = Math.abs(dy))) {
                dx /= ady;
                dy = Math.signum(dy);
            } else {
                dy /= adx;
                dx = Math.signum(dx);
            }
            double FULL = 23.0;
            double HALF = FULL / 2.0;
            dx = (1.0 + dx) / 2.0 * FULL;
            dy = FULL - (1.0 + dy) / 2.0 * FULL;
            float zLevel = hud.field_73735_i;
            Tessellator instance = Tessellator.func_178181_a();
            VertexBuffer tess = instance.func_178180_c();
            tess.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            if ((double)t <= 0.125) {
                this.addVertexAndTex(tess, HALF, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, dx, dy, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, dx, dy, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
            } else if ((double)t <= 0.375) {
                this.addVertexAndTex(tess, dx, dy, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, 0.0, 0.0, zLevel, base_x, base_y);
            } else if ((double)t <= 0.625) {
                this.addVertexAndTex(tess, 0.0, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, 0.0, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, dx, dy, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, 0.0, FULL, zLevel, base_x, base_y);
            } else if ((double)t <= 0.875) {
                this.addVertexAndTex(tess, 0.0, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, 0.0, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, 0.0, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, FULL, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, dx, dy, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
            } else if (t < 1.0f) {
                this.addVertexAndTex(tess, 0.0, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, 0.0, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, 0.0, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, FULL, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, FULL, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, FULL, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, dx, dy, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, dx, dy, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, HALF, HALF, zLevel, base_x, base_y);
            } else {
                this.addVertexAndTex(tess, 0.0, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, FULL, FULL, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, FULL, 0.0, zLevel, base_x, base_y);
                this.addVertexAndTex(tess, 0.0, 0.0, zLevel, base_x, base_y);
            }
            instance.func_78381_a();
        }
        String text = "" + mc.field_71439_g.field_71068_ca;
        FontRenderer fontrenderer = mc.field_71466_p;
        int x = base_x + (24 - fontrenderer.func_78256_a(text)) / 2;
        int y = base_y + (26 - fontrenderer.field_78288_b) / 2;
        fontrenderer.func_78276_b(text, x + 1, y, 0);
        fontrenderer.func_78276_b(text, x - 1, y, 0);
        fontrenderer.func_78276_b(text, x, y + 1, 0);
        fontrenderer.func_78276_b(text, x, y - 1, 0);
        fontrenderer.func_78276_b(text, x, y, 8453920);
    }

    private void addVertexAndTex(VertexBuffer tess, double dx, double dy, float zLevel, int base_x, int base_y) {
        tess.func_181662_b((double)base_x + dx, (double)base_y + dy, (double)zLevel);
        tess.func_187315_a((23.0 + dx) / 256.0, dy / 256.0);
        tess.func_181675_d();
    }

    public abstract class ScrollBar {
        final int TEX_LEFT_MAIN_LEFT;
        final int TEX_LEFT_BAR;
        final int TEX_LEFT_MAIN_RIGHT;
        final int TEX_TOP;
        final int TEX_WIDTH;
        final int TEX_HEIGHT;
        final float r;
        final float g;
        final float b;
        final RenderGameOverlayEvent.ElementType type;
        final int base_max;
        public int yellow_r = 1;
        public int yellow_g = 1;
        public int yellow_b = 0;
        float value = -1.0f;
        float prevValue = -1.0f;
        float yellowValue = -1.0f;
        float prevYellowValue = -1.0f;
        boolean shouldRender = false;
        int barWidth;
        boolean emergency = false;

        protected ScrollBar(int base_max, RenderGameOverlayEvent.ElementType type, float g, float b, float r) {
            this(46, 0, 16, 5, r, g, b, type, base_max);
        }

        protected ScrollBar(int tex_left_main_left, int tex_top, int tex_width, int tex_height, float r, float g, float b, RenderGameOverlayEvent.ElementType type, int base_max) {
            this(tex_left_main_left, tex_left_main_left + tex_width, tex_left_main_left + tex_width * 2, tex_top, tex_width, tex_height, r, g, b, type, base_max);
        }

        protected ScrollBar(int tex_left_main_left, int tex_left_bar, int tex_left_main_right, int tex_top, int tex_width, int tex_height, float r, float g, float b, RenderGameOverlayEvent.ElementType type, int base_max) {
            this.TEX_LEFT_MAIN_LEFT = tex_left_main_left;
            this.TEX_LEFT_BAR = tex_left_bar;
            this.TEX_LEFT_MAIN_RIGHT = tex_left_main_right;
            this.TEX_TOP = tex_top;
            this.TEX_WIDTH = tex_width;
            this.TEX_HEIGHT = tex_height;
            this.r = r;
            this.g = g;
            this.b = b;
            this.type = type;
            this.base_max = base_max;
        }

        public abstract float getCurrentValue(EntityPlayer var1, PlayerHandler var2);

        public float getMaxValue(EntityPlayer player, PlayerHandler handler) {
            return this.base_max;
        }

        public boolean shouldRender(EntityPlayer player, PlayerHandler handler) {
            return true;
        }

        public int getWidth() {
            return this.barWidth + 1;
        }

        public void render(GuiIngameForge hud, int x, int y) {
            int dx;
            int dw;
            int barWidth = this.barWidth;
            int renderValue = (int)Math.ceil((this.prevValue + HUDHandler.this.partialTime * (this.value - this.prevValue)) * (float)barWidth);
            int yellowRenderValue = (int)Math.ceil((this.prevYellowValue + HUDHandler.this.partialTime * (this.yellowValue - this.prevYellowValue)) * (float)barWidth);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            for (dx = 0; dx < barWidth; dx += dw) {
                dw = Math.min(dx + this.TEX_WIDTH, barWidth) - dx;
                hud.func_73729_b(x + dx, y, this.TEX_LEFT_MAIN_LEFT, this.TEX_TOP, dw, this.TEX_HEIGHT);
            }
            int cap_width = barWidth + 1 - dx;
            hud.func_73729_b(x + dx, y, this.TEX_LEFT_MAIN_RIGHT + this.TEX_WIDTH - cap_width, this.TEX_TOP, cap_width, this.TEX_HEIGHT);
            if (yellowRenderValue > renderValue) {
                GlStateManager.func_179124_c((float)this.yellow_r, (float)this.yellow_g, (float)this.yellow_b);
                for (dx = 0; dx < yellowRenderValue; dx += this.TEX_WIDTH) {
                    if (dx + this.TEX_WIDTH < renderValue) continue;
                    int ax = dx < renderValue ? renderValue : dx;
                    int w = Math.min(dx + this.TEX_WIDTH, yellowRenderValue) - ax;
                    hud.func_73729_b(x + ax, y, this.TEX_LEFT_BAR + (ax - dx), this.TEX_TOP, w, this.TEX_HEIGHT);
                }
            }
            GlStateManager.func_179124_c((float)this.r, (float)this.g, (float)this.b);
            for (dx = 0; dx < renderValue; dx += this.TEX_WIDTH) {
                int w = dx + this.TEX_WIDTH > renderValue ? renderValue - dx : this.TEX_WIDTH;
                hud.func_73729_b(x + dx, y, this.TEX_LEFT_BAR, this.TEX_TOP, w, this.TEX_HEIGHT);
            }
            if (this.emergency) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)HUDHandler.this.intensity);
                for (dx = 0; dx < barWidth; dx += dw) {
                    dw = Math.min(dx + this.TEX_WIDTH, barWidth) - dx;
                    hud.func_73729_b(x + dx, y, this.TEX_LEFT_MAIN_LEFT, this.TEX_TOP + this.TEX_HEIGHT, dw, this.TEX_HEIGHT);
                }
                cap_width = barWidth + 1 - dx;
                hud.func_73729_b(x + dx, y, this.TEX_LEFT_MAIN_RIGHT + this.TEX_WIDTH - cap_width, this.TEX_TOP + this.TEX_HEIGHT, cap_width, this.TEX_HEIGHT);
            }
        }

        public void clientTick() {
            Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
            if (!(renderViewEntity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayerSP thePlayer = (EntityPlayerSP)renderViewEntity;
            PlayerHandler handler = PlayerHandlerRegistry.INSTANCE.getPlayerHandler((EntityPlayer)thePlayer);
            this.prevValue = this.value;
            this.prevYellowValue = this.yellowValue;
            this.shouldRender = this.shouldRender((EntityPlayer)thePlayer, handler);
            this.emergency = this.isEmergency(thePlayer, handler);
            if (!this.shouldRender) {
                this.prevValue = -1.0f;
                this.value = -1.0f;
                this.prevYellowValue = -1.0f;
                this.yellowValue = -1.0f;
                return;
            }
            float currentValue = this.getCurrentValue((EntityPlayer)thePlayer, handler);
            float maxValue = this.getMaxValue((EntityPlayer)thePlayer, handler);
            float nextValue = maxValue <= currentValue || maxValue <= 0.0f ? 1.0f : Math.max(currentValue / maxValue, 0.0f);
            this.barWidth = (int)(maxValue / (float)this.base_max * 80.0f + 0.5f);
            if (this.value == -1.0f) {
                this.yellowValue = nextValue;
                this.value = nextValue;
            } else {
                this.value = nextValue * 0.4f + this.value * 0.6f;
                this.yellowValue = Math.max(this.value, this.yellowValue - 0.01f);
            }
            if (this.prevValue == -1.0f) {
                this.prevValue = this.value;
                this.prevYellowValue = this.yellowValue;
            }
        }

        protected abstract boolean isEmergency(EntityPlayerSP var1, PlayerHandler var2);
    }
}

