/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.minesouls.config;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration configuration;
    static ArrayList<Field> configFields;
    static Map<Class, Property.Type> types;
    static HashMap<Field, Property> properties;
    static HashSet<String> configurableCategories;

    public static void addClass(Class clazz, boolean configurable) {
        if (configurable) {
            configurableCategories.add(ConfigHandler.getSimpleName(clazz));
        }
        for (Field field : clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            field.setAccessible(true);
            configFields.add(field);
        }
        configFields.sort((o1, o2) -> o1.toString().compareTo(o2.toString()));
    }

    public static void buildConfig(File file) {
        try {
            TObjectIntHashMap categoryHashes = new TObjectIntHashMap();
            for (Field field : configFields) {
                Class<?> declaringClass = field.getDeclaringClass();
                String simpleName = ConfigHandler.getSimpleName(declaringClass);
                categoryHashes.putIfAbsent((Object)simpleName, 0);
                int hash = categoryHashes.get((Object)simpleName);
                hash = hash * 31 + field.getName().hashCode();
                hash = hash * 31 + field.get(null).hashCode();
                hash = hash * 31 + field.getType().getName().hashCode();
                categoryHashes.put((Object)simpleName, hash);
            }
            configuration = new Configuration(file);
            configuration.load();
            for (Field configField : configFields) {
                Class<?> type = configField.getType();
                if (!types.containsKey(type)) continue;
                String defaultValue = configField.get(null).toString();
                Class<?> declaringClass = configField.getDeclaringClass();
                String simpleName = ConfigHandler.getSimpleName(declaringClass);
                Property.Type expectedType = types.get(type);
                Property prop = configuration.get(simpleName, configField.getName(), defaultValue, null, expectedType);
                String currentDeclaredValue = prop.getString();
                if (prop.getType() != expectedType) {
                    configuration.getCategory(simpleName).remove((Object)configField.getName());
                    prop = configuration.get(simpleName, configField.getName(), defaultValue, null, expectedType);
                }
                properties.put(configField, prop);
                int versionHash = categoryHashes.get((Object)simpleName);
                int foundHash = configuration.get(simpleName, "VersionHash", versionHash, "Hash Value to allow values to be updated when version changes. Set to 0 to prevent values being changed.").getInt();
                if (foundHash == versionHash || foundHash == 0) continue;
                if (!Objects.equals(currentDeclaredValue, defaultValue)) {
                    String oldValuesCategory = simpleName + "_old_values";
                    configuration.get(oldValuesCategory, configField.getName(), defaultValue, null, expectedType);
                    configuration.getCategory(oldValuesCategory).setComment("Contains older values that were overwritten when the MineSouls version changed");
                }
                prop.setValue(defaultValue);
            }
            ConfigHandler.reloadPropertiesFromConfig();
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static String getSimpleName(Class<?> declaringClass) {
        String simpleName = declaringClass.getName();
        simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
        return simpleName;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent event) throws IllegalAccessException {
        ConfigHandler.reloadPropertiesFromConfig();
    }

    public static void reloadPropertiesFromConfig() throws IllegalAccessException {
        for (Map.Entry<Field, Property> entry : properties.entrySet()) {
            Constable o;
            Field configField = entry.getKey();
            Class<?> type = configField.getType();
            Property prop = entry.getValue();
            if (type == Float.TYPE) {
                o = Float.valueOf((float)prop.getDouble());
            } else if (type == Integer.TYPE) {
                o = prop.getInt();
            } else if (type == Boolean.TYPE) {
                o = Boolean.valueOf(prop.getBoolean());
            } else if (type == Double.TYPE) {
                o = prop.getDouble();
            } else {
                throw new IllegalStateException();
            }
            configField.set(null, o);
        }
        configuration.save();
    }

    static {
        configFields = new ArrayList();
        types = ImmutableMap.builder().put(Integer.TYPE, (Object)Property.Type.INTEGER).put(Boolean.TYPE, (Object)Property.Type.BOOLEAN).put(Float.TYPE, (Object)Property.Type.DOUBLE).put(Double.TYPE, (Object)Property.Type.DOUBLE).build();
        properties = new HashMap();
        configurableCategories = new HashSet();
        MinecraftForge.EVENT_BUS.register(ConfigHandler.class);
    }
}

