/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.minesouls;

import com.rwtema.minesouls.Helper;
import com.rwtema.minesouls.MineSouls;
import com.rwtema.minesouls.config.DifficultyConfig;
import com.rwtema.minesouls.playerHandler.PlayerHandler;
import com.rwtema.minesouls.playerHandler.PlayerHandlerRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MineSoulsControllerHooks {
    public static boolean shouldSlowPlayer(EntityPlayer player) {
        if (!MineSouls.isMineSoulsOnServer()) {
            return player.func_184587_cr();
        }
        return MineSoulsControllerHooks.isPlayerUsingButNotBlocking(player) || PlayerHandlerRegistry.INSTANCE.getPlayerHandler((EntityPlayer)player).staggeredTimer > 0;
    }

    public static boolean isPlayerUsingOrHoldingSword(EntityPlayer player) {
        if (player.func_184587_cr()) {
            return true;
        }
        ItemStack heldItemMainhand = player.func_184614_ca();
        if (Helper.isSword(heldItemMainhand)) {
            Minecraft minecraft = Minecraft.func_71410_x();
            RayTraceResult trace = minecraft.field_71476_x;
            return trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK || minecraft.field_71441_e.func_180495_p(trace.func_178782_a()).func_177230_c() != Blocks.field_150321_G;
        }
        return false;
    }

    public static boolean isPlayerUsingButNotBlocking(EntityPlayer player) {
        ItemStack stack;
        return player.func_184587_cr() && ((stack = player.func_184607_cu()) == null || stack.func_77973_b().func_77661_b(stack) != EnumAction.BLOCK);
    }

    public static float getAttackStrengthModifier(EntityPlayer player, float adjustTicks) {
        float v = player.func_184825_o(adjustTicks);
        if (!MineSouls.isMineSoulsOnServer()) {
            return v;
        }
        return v < 1.0f ? 0.0f : 1.0f;
    }

    public static void dontResetCooldown(EntityPlayer player) {
        if (!MineSouls.isMineSoulsOnServer()) {
            player.func_184821_cY();
        }
    }

    public static void resetCooldownIfFull(EntityPlayer player) {
        if (!MineSouls.isMineSoulsOnServer() || player.func_184825_o(1.0f) == 1.0f) {
            player.func_184821_cY();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void swingArmIfFull(EntityPlayerSP player, EnumHand hand) {
        if (!MineSouls.isMineSoulsOnServer() || player.func_184825_o(1.0f) == 1.0f) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void attackEntity(PlayerControllerMP controllerMP, EntityPlayer playerIn, Entity targetEntity) {
        if (!MineSouls.isMineSoulsOnServer() || playerIn.func_184825_o(1.0f) == 1.0f) {
            controllerMP.func_78764_a(playerIn, targetEntity);
        }
    }

    public static void addFoodStats(FoodStats foodStats, int foodLevelIn, float foodSaturationModifier) {
        EntityPlayer player;
        foodStats.func_75122_a(foodLevelIn, foodSaturationModifier);
        if (MineSouls.isMineSoulsOnServer() && (player = PlayerHandlerRegistry.findFoodStatOwner(foodStats)) != null) {
            player.func_70691_i((float)foodLevelIn * DifficultyConfig.FOOD_HEAL_MODIFIER);
        }
    }

    public static boolean canPlayerEat(EntityPlayer player, boolean ignoreHunger) {
        return player.func_71043_e(ignoreHunger) || MineSouls.isMineSoulsOnServer() && player.func_110143_aJ() < player.func_110138_aP() && DifficultyConfig.FOOD_HEAL_MODIFIER > 0.0f;
    }

    public static void onFoodEaten(FoodStats foodStats, ItemFood foodItem, ItemStack stack) {
        EntityPlayer player;
        foodStats.func_151686_a(foodItem, stack);
        if (MineSouls.isMineSoulsOnServer() && (player = PlayerHandlerRegistry.findFoodStatOwner(foodStats)) != null) {
            player.func_70691_i((float)foodItem.func_150905_g(stack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleMovementInput(MovementInput input) {
        input.func_78898_a();
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (thePlayer != null && thePlayer.field_71158_b == input) {
            PlayerHandler handler = PlayerHandlerRegistry.INSTANCE.getPlayerHandler((EntityPlayer)thePlayer);
            if (handler.dodgeTimer > 0) {
                input.field_78900_b = handler.dodgeF;
                input.field_78902_a = handler.dodgeS;
                input.field_78901_c = false;
                input.field_78899_d = false;
                thePlayer.field_70177_z = thePlayer.field_70126_B = handler.dodgeY;
            }
        }
    }
}

