/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import omtteam.omlib.compatability.minecraft.CompatCommandBase;
import omtteam.omlib.handler.ConfigHandler;
import omtteam.omlib.handler.OwnerShareHandler;
import omtteam.omlib.util.Player;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.compat.ChatTools;

public class CommandShareOwner
extends CompatCommandBase {
    @Override
    @Nonnull
    public String getName() {
        return "omshareowner";
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public String getUsage(ICommandSender sender) {
        return "'<add|del> <name to share>' or list";
    }

    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] params) {
        if ((params.length == 1 && params[0].equals("list")) == (params.length == 2)) {
            ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString(this.getUsage(sender)));
            return;
        }
        try {
            String command;
            String shareName = "";
            if (params.length > 1) {
                shareName = params[1];
            }
            if ((command = params[0]).equals("add")) {
                if (!ConfigHandler.offlineModeSupport && PlayerUtil.getPlayerUUID(shareName) != null) {
                    Player sharePlayer = new Player(PlayerUtil.getPlayerUUID(shareName), shareName);
                    Player owner = new Player(PlayerUtil.getPlayerUUID(sender.func_70005_c_()), sender.func_70005_c_());
                    OwnerShareHandler.getInstance().addSharePlayer(owner, sharePlayer, sender);
                }
            } else if (command.equals("del")) {
                if (!ConfigHandler.offlineModeSupport && PlayerUtil.getPlayerUUID(shareName) != null) {
                    Player sharePlayer = new Player(PlayerUtil.getPlayerUUID(shareName), shareName);
                    Player owner = new Player(PlayerUtil.getPlayerUUID(sender.func_70005_c_()), sender.func_70005_c_());
                    OwnerShareHandler.getInstance().removeSharePlayer(owner, sharePlayer, sender);
                }
            } else if (command.equals("list")) {
                Player owner = new Player(PlayerUtil.getPlayerUUID(sender.func_70005_c_()), sender.func_70005_c_());
                OwnerShareHandler.getInstance().printSharePlayers(owner, sender);
            }
        }
        catch (NumberFormatException e) {
            ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString("Please supply a valid name and command"));
        }
    }

    public int func_82362_a() {
        return 0;
    }
}

