/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.UUID;

public class Player
implements Serializable {
    private UUID uuid;
    private String name;

    public Player(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Player player = (Player)o;
        if (this.getUuid() != null ? !this.getUuid().equals(player.getUuid()) : player.getUuid() != null) {
            return false;
        }
        return this.getName().toLowerCase().equals(player.getName().toLowerCase());
    }

    public int hashCode() {
        int result = this.getUuid() != null ? this.getUuid().hashCode() : 0;
        result = 31 * result + this.getName().toLowerCase().hashCode();
        return result;
    }

    public static void writeToByteBuf(Player player, ByteBuf buf) {
        buf.writeInt(player.getName().length());
        buf.writeBytes(player.getName().getBytes());
        buf.writeInt(player.getUuid().toString().length());
        buf.writeBytes(player.getUuid().toString().getBytes());
    }

    public static Player readFromByteBuf(ByteBuf buf) {
        int length = buf.readInt();
        String name = new String(buf.readBytes(length).array());
        length = buf.readInt();
        UUID uuid = UUID.fromString(new String(buf.readBytes(length).array()));
        return new Player(uuid, name);
    }
}

