/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.tileentity;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.UsernameCache;
import omtteam.omlib.handler.ConfigHandler;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.DebugHandler;
import omtteam.omlib.util.Player;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.TrustedPlayer;

public interface ITrustedPlayersManager {
    @ParametersAreNonnullByDefault
    default public boolean addTrustedPlayer(String name) {
        TrustedPlayer trustedPlayer = new TrustedPlayer(name);
        trustedPlayer.uuid = PlayerUtil.getPlayerUUID(name);
        if (!((TileEntityOwnedBlock)((Object)this)).func_145831_w().field_72995_K) {
            Player player = null;
            boolean foundPlayer = false;
            for (Map.Entry serverName : UsernameCache.getMap().entrySet()) {
                if (!name.equals(serverName.getValue())) continue;
                player = new Player((UUID)serverName.getKey(), (String)serverName.getValue());
                foundPlayer = true;
                break;
            }
            if (!foundPlayer) {
                player = new Player(null, name);
            }
            if (!foundPlayer && !ConfigHandler.offlineModeSupport) {
                DebugHandler.getInstance().sendMessageToDebugChat("Did not find player named " + name + "in the username cache.");
                return false;
            }
            if (ConfigHandler.offlineModeSupport) {
                if (PlayerUtil.isPlayerOwner(player, (TileEntityOwnedBlock)((Object)this))) {
                    DebugHandler.getInstance().sendMessageToDebugChat("You cannot add an owner!");
                    return false;
                }
            } else if (trustedPlayer.uuid == null || PlayerUtil.isPlayerOwner(player, (TileEntityOwnedBlock)((Object)this))) {
                if (trustedPlayer.uuid != null) {
                    DebugHandler.getInstance().sendMessageToDebugChat("You cannot add an owner!");
                } else {
                    DebugHandler.getInstance().sendMessageToDebugChat("Did not find player named " + name + "in the username cache.");
                }
                return false;
            }
            if (trustedPlayer.uuid != null || ConfigHandler.offlineModeSupport) {
                for (TrustedPlayer existPlayer : this.getTrustedPlayers()) {
                    if (ConfigHandler.offlineModeSupport) {
                        if (!existPlayer.getName().toLowerCase().equals(name.toLowerCase())) continue;
                        DebugHandler.getInstance().sendMessageToDebugChat("Already on trust list!");
                        return false;
                    }
                    if (!existPlayer.getName().toLowerCase().equals(name.toLowerCase()) && !trustedPlayer.uuid.equals(existPlayer.uuid)) continue;
                    return false;
                }
                DebugHandler.getInstance().sendMessageToDebugChat("Sucessfully added " + name + ".");
                this.getTrustedPlayers().add(trustedPlayer);
                return true;
            }
        }
        return false;
    }

    default public boolean removeTrustedPlayer(String name) {
        for (TrustedPlayer player : this.getTrustedPlayers()) {
            if (!player.getName().equals(name)) continue;
            this.getTrustedPlayers().remove(player);
            DebugHandler.getInstance().sendMessageToDebugChat("Sucessfully removed " + name + ".");
            return true;
        }
        DebugHandler.getInstance().sendMessageToDebugChat("Could not remove " + name + ".");
        return false;
    }

    default public TrustedPlayer getTrustedPlayer(String name) {
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            if (!trustedPlayer.name.equals(name)) continue;
            return trustedPlayer;
        }
        return null;
    }

    default public TrustedPlayer getTrustedPlayer(UUID uuid) {
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            if (!trustedPlayer.uuid.equals(uuid)) continue;
            return trustedPlayer;
        }
        return null;
    }

    public List<TrustedPlayer> getTrustedPlayers();

    default public NBTTagList getTrustedPlayersAsNBT() {
        NBTTagList nbt = new NBTTagList();
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            NBTTagCompound nbtPlayer = new NBTTagCompound();
            nbtPlayer.func_74778_a("name", trustedPlayer.name);
            nbtPlayer.func_74757_a("canOpenGUI", trustedPlayer.canOpenGUI);
            nbtPlayer.func_74757_a("canChangeTargeting", trustedPlayer.canChangeTargeting);
            nbtPlayer.func_74757_a("admin", trustedPlayer.admin);
            if (trustedPlayer.uuid != null) {
                nbtPlayer.func_74778_a("UUID", trustedPlayer.uuid.toString());
            } else if (PlayerUtil.getPlayerUUID(trustedPlayer.name) != null) {
                nbtPlayer.func_74778_a("UUID", PlayerUtil.getPlayerUUID(trustedPlayer.name).toString());
            }
            nbt.func_74742_a((NBTBase)nbtPlayer);
        }
        return nbt;
    }

    default public void buildTrustedPlayersFromNBT(NBTTagList nbt) {
        this.getTrustedPlayers().clear();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            if (!nbt.func_150305_b(i).func_74779_i("name").equals("")) {
                NBTTagCompound nbtPlayer = nbt.func_150305_b(i);
                TrustedPlayer trustedPlayer = new TrustedPlayer(nbtPlayer.func_74779_i("name"));
                trustedPlayer.canOpenGUI = nbtPlayer.func_74767_n("canOpenGUI");
                trustedPlayer.canChangeTargeting = nbtPlayer.func_74767_n("canChangeTargeting");
                trustedPlayer.admin = nbtPlayer.func_74767_n("admin");
                trustedPlayer.uuid = nbtPlayer.func_74764_b("UUID") ? PlayerUtil.getPlayerUIDUnstable(nbtPlayer.func_74779_i("UUID")) : PlayerUtil.getPlayerUUID(trustedPlayer.name);
                if (trustedPlayer.uuid == null) continue;
                this.getTrustedPlayers().add(trustedPlayer);
                continue;
            }
            if (!nbt.func_150305_b(i).func_74779_i("name").equals("")) continue;
            TrustedPlayer trustedPlayer = new TrustedPlayer(nbt.func_150307_f(i));
            Logger.getGlobal().info("found legacy trusted Player: " + nbt.func_150307_f(i));
            trustedPlayer.uuid = PlayerUtil.getPlayerUUID(trustedPlayer.name);
            if (trustedPlayer.uuid == null) continue;
            this.getTrustedPlayers().add(trustedPlayer);
        }
    }
}

