/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.power;

import net.minecraftforge.energy.IEnergyStorage;

public class OMEnergyStorage
implements IEnergyStorage {
    protected int energy;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public OMEnergyStorage(int capacity) {
        this(capacity, capacity, capacity);
    }

    public OMEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public OMEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setMaxReceive(int max) {
        this.maxReceive = max;
    }

    public void setCapacity(int max) {
        this.capacity = max;
    }

    public void setEnergyStored(int stored) {
        this.energy = stored > 0 ? Math.min(stored, this.capacity) : 0;
    }

    public void modifyEnergyStored(int change) {
        this.energy = change >= 0 ? Math.min(this.energy + change, this.capacity) : Math.max(this.energy - change, 0);
    }

    public boolean canExtract() {
        return this.maxExtract > 0;
    }

    public boolean canReceive() {
        return this.maxReceive > 0;
    }
}

