/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunklistener;

import net.malisis.core.block.IComponent;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.malisis.core.util.chunkblock.ChunkCallbackRegistry;
import net.malisis.core.util.chunklistener.IBlockListener;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;

@AutoLoad(value=true)
public class ChunkListener {
    private static final CallbackResult<Void> CANCELLED = CallbackResult.builder().forceCancel(true).withReturn(true).result();
    private static ChunkCallbackRegistry<IBlockListenerCallback, IBlockListenerPredicate, Void> preRegistry = new ChunkCallbackRegistry();
    private static ChunkCallbackRegistry<IBlockListenerCallback, IBlockListenerPredicate, Void> postRegistry = new ChunkCallbackRegistry();

    public ChunkListener() {
        MalisisRegistry.onPreSetBlock((x$0, xva$1, xva$2, xva$3) -> preRegistry.processCallbacks(x$0, (Object)xva$1, (Object)xva$2, (Object)xva$3), ICallback.CallbackOption.of());
        MalisisRegistry.onPreSetBlock((x$0, xva$1, xva$2, xva$3) -> postRegistry.processCallbacks(x$0, (Object)xva$1, (Object)xva$2, (Object)xva$3), ICallback.CallbackOption.of());
        preRegistry.registerCallback(this::callPreListener, ICallback.CallbackOption.of(this::isValidPreListener));
        postRegistry.registerCallback(this::callPostListener, ICallback.CallbackOption.of(this::isValidPostListener));
    }

    public boolean callPreListener(Chunk chunk, BlockPos listener, BlockPos modified, IBlockState oldState, IBlockState newState) {
        IBlockListener.Pre bl = IComponent.getComponent(IBlockListener.Pre.class, chunk.func_177412_p().func_180495_p(listener).func_177230_c());
        return bl.onBlockSet(chunk.func_177412_p(), listener, modified, oldState, newState);
    }

    public boolean isValidPreListener(Chunk chunk, BlockPos listener, BlockPos modified, IBlockState oldState, IBlockState newState) {
        if (listener.equals((Object)modified)) {
            return false;
        }
        IBlockListener.Pre bl = IComponent.getComponent(IBlockListener.Pre.class, chunk.func_177412_p().func_180495_p(listener).func_177230_c());
        return bl != null && bl.isInRange(listener, modified);
    }

    public boolean callPostListener(Chunk chunk, BlockPos listener, BlockPos modified, IBlockState oldState, IBlockState newState) {
        IBlockListener.Post bl = IComponent.getComponent(IBlockListener.Post.class, chunk.func_177412_p().func_180495_p(listener).func_177230_c());
        bl.onBlockSet(chunk.func_177412_p(), listener, modified, oldState, newState);
        return true;
    }

    public boolean isValidPostListener(Chunk chunk, BlockPos listener, BlockPos modified, IBlockState oldState, IBlockState newState) {
        if (listener.equals((Object)modified)) {
            return false;
        }
        IBlockListener.Post bl = IComponent.getComponent(IBlockListener.Post.class, chunk.func_177412_p().func_180495_p(listener).func_177230_c());
        return bl != null && bl.isInRange(listener, modified);
    }

    public static interface IBlockListenerPredicate
    extends ChunkCallbackRegistry.IChunkCallbackPredicate {
        @Override
        default public boolean apply(Chunk chunk, BlockPos listener, Object ... params) {
            return this.apply(chunk, listener, (BlockPos)params[0], (IBlockState)params[1], (IBlockState)params[2]);
        }

        public boolean apply(Chunk var1, BlockPos var2, BlockPos var3, IBlockState var4, IBlockState var5);
    }

    public static interface IBlockListenerCallback
    extends ChunkCallbackRegistry.IChunkCallback<Void> {
        @Override
        default public CallbackResult<Void> call(Chunk chunk, BlockPos listener, Object ... params) {
            return this.call(chunk, listener, (BlockPos)params[0], (IBlockState)params[1], (IBlockState)params[2]) ? CallbackResult.noResult() : CANCELLED;
        }

        public boolean call(Chunk var1, BlockPos var2, BlockPos var3, IBlockState var4, IBlockState var5);
    }
}

