/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.Objects;
import net.malisis.core.block.component.WallComponent;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.ConnectedIconsProvider;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IconProviderBuilder {
    Type type = Type.DEFAULT;
    String prefix;
    String defaultName;
    Icon defaultIcon;
    Icon connectedIcon;
    Map<EnumFacing, Icon> sidesIcons = Maps.newHashMap();
    Table<IProperty<?>, Object, Icon> stateIcons = HashBasedTable.create();
    IProperty<?> currentProperty;
    Icon insideIcon;
    Map<String, Icon> shapeIcons = Maps.newHashMap();

    IconProviderBuilder(String prefix, Icon icon) {
        this.prefix = prefix;
        this.defaultIcon = icon;
    }

    IconProviderBuilder(String prefix, String name) {
        this.prefix = prefix;
        this.defaultIcon = this.icon(name);
    }

    private Icon icon(String name) {
        return Icon.from(this.prefix + name);
    }

    private void setType(Type type) {
        if (this.type != Type.DEFAULT && this.type != type) {
            throw new IllegalArgumentException("Cannot set type to " + (Object)((Object)type) + " because it's already set to " + (Object)((Object)this.type));
        }
        this.type = type;
    }

    public IconProviderBuilder withSide(EnumFacing side, Icon icon) {
        this.setType(Type.SIDES);
        this.sidesIcons.put(Objects.requireNonNull(side), icon);
        return this;
    }

    public IconProviderBuilder withSide(EnumFacing side, String iconName) {
        return this.withSide(side, this.icon(iconName));
    }

    public IconProviderBuilder connected() {
        return this.connectedWith(Icon.from(this.defaultIcon.func_94215_i() + "2"));
    }

    public IconProviderBuilder connectedWith(Icon icon) {
        this.setType(Type.CONNECTED);
        this.connectedIcon = Objects.requireNonNull(icon);
        return this;
    }

    public IconProviderBuilder connectedWith(String iconName) {
        return this.connectedWith(this.icon(iconName));
    }

    public IconProviderBuilder forProperty(IProperty<?> property) {
        this.setType(Type.STATE);
        this.currentProperty = property;
        return this;
    }

    public IconProviderBuilder withValue(Object value, Icon icon) {
        if (this.currentProperty == null) {
            throw new IllegalStateException("You must set the property first.");
        }
        if (!this.currentProperty.func_177700_c().contains(value)) {
            throw new IllegalStateException("The property " + this.currentProperty + "(" + this.currentProperty.getClass().getSimpleName() + ") doesn't not contain value " + value);
        }
        this.stateIcons.put(this.currentProperty, value, Preconditions.checkNotNull((Object)((Object)icon)));
        return this;
    }

    public IconProviderBuilder withValue(Object value, String iconName) {
        return this.withValue(value, this.icon(iconName));
    }

    public IconProviderBuilder wall(Icon insideIcon) {
        this.setType(Type.WALL);
        this.insideIcon = insideIcon;
        return this;
    }

    public IconProviderBuilder wall(String insideIconName) {
        return this.wall(this.icon(insideIconName));
    }

    public IconProviderBuilder forShape(String shapeName, Icon icon) {
        this.setType(Type.MODEL);
        this.shapeIcons.put(shapeName, (Icon)((Object)Preconditions.checkNotNull((Object)((Object)icon))));
        return this;
    }

    public IconProviderBuilder forShape(String shapeName, String iconName) {
        this.setType(Type.MODEL);
        this.shapeIcons.put(shapeName, this.icon(iconName));
        return this;
    }

    private IBlockIconProvider.IStatesIconProvider getStateIconProvider() {
        return state -> state.func_177228_b().keySet().stream().map(prop -> (Icon)((Object)((Object)((Object)this.stateIcons.get(prop, (Object)state.func_177229_b(prop)))))).filter(Objects::nonNull).findFirst().orElse(this.defaultIcon);
    }

    private IBlockIconProvider getWallIconProvider() {
        return (state, side) -> {
            if (side == EnumFacing.SOUTH || side == EnumFacing.WEST && WallComponent.isCorner(state)) {
                return this.insideIcon;
            }
            return this.defaultIcon;
        };
    }

    public IIconProvider build() {
        switch (this.type) {
            case DEFAULT: {
                return () -> this.defaultIcon;
            }
            case SIDES: {
                return side -> (Icon)((Object)((Object)com.google.common.base.Objects.firstNonNull((Object)((Object)this.sidesIcons.get(side)), (Object)((Object)this.defaultIcon))));
            }
            case STATE: {
                return this.getStateIconProvider();
            }
            case WALL: {
                return this.getWallIconProvider();
            }
            case CONNECTED: {
                return new ConnectedIconsProvider(this);
            }
        }
        return null;
    }

    private static enum Type {
        DEFAULT,
        SIDES,
        CONNECTED,
        STATE,
        WALL,
        MODEL;

    }
}

