/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import com.google.common.io.Files;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.SouthFace;
import net.malisis.core.renderer.font.CharData;
import net.malisis.core.renderer.font.FontGenerator;
import net.malisis.core.renderer.font.FontGeneratorOptions;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MinecraftFont;
import net.malisis.core.renderer.font.StringWalker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class MalisisFont {
    public static MalisisFont minecraftFont = new MinecraftFont();
    private static Pattern pattern = Pattern.compile("\\{(.*?)}");
    protected Font font;
    protected FontRenderContext frc;
    protected FontGeneratorOptions fontGeneratorOptions = FontGeneratorOptions.DEFAULT;
    protected CharData[] charData = new CharData[256];
    protected ResourceLocation textureRl;
    protected int size;
    protected boolean drawingShadow = false;

    public MalisisFont(File fontFile) {
        this(MalisisFont.load(fontFile, FontGeneratorOptions.DEFAULT), null);
    }

    public MalisisFont(File fontFile, FontGeneratorOptions options) {
        this(MalisisFont.load(fontFile, options), options);
    }

    public MalisisFont(ResourceLocation fontFile) {
        this(MalisisFont.load(fontFile, FontGeneratorOptions.DEFAULT), null);
    }

    public MalisisFont(ResourceLocation fontFile, FontGeneratorOptions options) {
        this(MalisisFont.load(fontFile, options), options);
    }

    public MalisisFont(Font font) {
        this(font, null);
    }

    public MalisisFont(Font font, FontGeneratorOptions options) {
        this.font = font;
        if (font == null) {
            return;
        }
        if (options != null) {
            this.fontGeneratorOptions = options;
        }
        this.loadCharacterData();
        this.loadTexture(false);
    }

    public ResourceLocation getResourceLocation() {
        return this.textureRl;
    }

    public void generateTexture(boolean debug) {
        this.fontGeneratorOptions.debug = debug;
        this.loadCharacterData();
        this.loadTexture(true);
    }

    public CharData getCharData(char c) {
        if (c < '\u0000' || c > this.charData.length) {
            c = (char)63;
        }
        return this.charData[c];
    }

    public Shape getShape(String text, float fontSize) {
        text = this.processString(text, null);
        ArrayList<Face> faces = new ArrayList<Face>();
        float offset = 0.0f;
        float factor = this.fontGeneratorOptions.fontSize / fontSize;
        for (int i = 0; i < text.length(); ++i) {
            CharData cd = this.getCharData(text.charAt(i));
            if (cd.getChar() != ' ') {
                SouthFace f = new SouthFace();
                f.scale(cd.getFullWidth(this.fontGeneratorOptions) / factor, cd.getFullHeight(this.fontGeneratorOptions) / factor, 0.0f);
                f.translate((offset - this.fontGeneratorOptions.mx) / factor, -this.fontGeneratorOptions.my / factor, 0.0f);
                f.setTexture(cd.getIcon());
                faces.add(f);
            }
            offset += cd.getCharWidth();
        }
        return new Shape(faces).storeState();
    }

    protected void prepare(MalisisRenderer<?> renderer, float x, float y, float z, FontOptions options) {
        boolean isGui = renderer instanceof GuiRenderer;
        renderer.next(7, DefaultVertexFormats.field_181709_i);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureRl);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)(y + (isGui ? 0.0f : options.getFontScale())), (float)z);
        if (!isGui) {
            GL11.glScalef((float)0.11111111f, (float)-0.11111111f, (float)0.11111111f);
        }
    }

    protected void clean(MalisisRenderer<?> renderer, boolean isDrawing) {
        if (isDrawing) {
            renderer.next(MalisisRenderer.malisisVertexFormat);
        } else {
            renderer.draw();
        }
        if (renderer instanceof GuiRenderer) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(((GuiRenderer)renderer).getDefaultTexture().getResourceLocation());
        }
        GL11.glPopMatrix();
    }

    protected void prepareShadow(MalisisRenderer<?> renderer) {
        this.drawingShadow = true;
        if (renderer instanceof GuiRenderer) {
            return;
        }
        renderer.next();
        GL11.glPolygonOffset((float)3.0f, (float)3.0f);
        GL11.glEnable((int)32823);
    }

    protected void cleanShadow(MalisisRenderer<?> renderer) {
        this.drawingShadow = false;
        if (renderer instanceof GuiRenderer) {
            return;
        }
        renderer.next();
        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
        GL11.glDisable((int)32823);
    }

    protected void prepareLines(MalisisRenderer<?> renderer, FontOptions options) {
        renderer.next(DefaultVertexFormats.field_181706_f);
        renderer.disableTextures();
    }

    protected void cleanLines(MalisisRenderer<?> renderer) {
        renderer.next();
        renderer.enableTextures();
    }

    public void render(MalisisRenderer<?> renderer, String text, float x, float y, float z, FontOptions options) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        boolean isDrawing = renderer.isDrawing();
        this.prepare(renderer, x, y, z, options);
        text = this.processString(text, options);
        if (options.hasShadow()) {
            this.prepareShadow(renderer);
            this.drawString(text, options);
            this.cleanShadow(renderer);
        }
        this.drawString(text, options);
        if (this.hasLines(text, options)) {
            this.prepareLines(renderer, options);
            if (options.hasShadow()) {
                this.prepareShadow(renderer);
                this.drawLines(text, options);
                this.cleanShadow(renderer);
            }
            this.drawLines(text, options);
            this.cleanLines(renderer);
        }
        this.clean(renderer, isDrawing);
    }

    protected void drawString(String text, FontOptions options) {
        float x = 0.0f;
        options.resetLineOptions();
        StringWalker walker = new StringWalker(text, this, options);
        walker.applyStyles(true);
        while (walker.walk()) {
            CharData cd = this.getCharData(walker.getChar());
            this.drawChar(cd, x, 0.0f, options);
            if (options.isBold()) {
                this.drawChar(cd, x + options.getFontScale(), 0.0f, options);
            }
            x += walker.getWidth();
        }
    }

    protected void drawChar(CharData cd, float offsetX, float offsetY, FontOptions options) {
        int color;
        if (Character.isWhitespace(cd.getChar())) {
            return;
        }
        VertexBuffer buffer = Tessellator.func_178181_a().func_178180_c();
        float factor = options.getFontScale() / this.fontGeneratorOptions.fontSize * 9.0f;
        float w = cd.getFullWidth(this.fontGeneratorOptions) * factor;
        float h = cd.getFullHeight(this.fontGeneratorOptions) * factor;
        float i = options.isItalic() ? options.getFontScale() : 0.0f;
        int n = color = this.drawingShadow ? options.getShadowColor() : options.getColor();
        if (this.drawingShadow) {
            offsetX += options.getFontScale();
            offsetY += options.getFontScale();
        }
        buffer.func_181662_b((double)(offsetX + i), (double)offsetY, 0.0);
        buffer.func_187315_a((double)cd.u(), (double)cd.v());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX - i), (double)(offsetY + h), 0.0);
        buffer.func_187315_a((double)cd.u(), (double)cd.V());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX + w - i), (double)(offsetY + h), 0.0);
        buffer.func_187315_a((double)cd.U(), (double)cd.V());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX + w + i), (double)offsetY, 0.0);
        buffer.func_187315_a((double)cd.U(), (double)cd.v());
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
    }

    protected void drawLines(String text, FontOptions options) {
        float x = 0.0f;
        options.resetLineOptions();
        StringWalker walker = new StringWalker(text, this, options);
        walker.applyStyles(true);
        while (walker.walk()) {
            if (walker.isFormatted()) continue;
            CharData cd = this.getCharData(walker.getChar());
            if (options.isUnderline()) {
                this.drawLineChar(cd, x, this.getStringHeight(options) + options.getFontScale(), options);
            }
            if (options.isStrikethrough()) {
                this.drawLineChar(cd, x, this.getStringHeight(options) * 0.5f + options.getFontScale(), options);
            }
            x += walker.getWidth();
        }
    }

    protected void drawLineChar(CharData cd, float offsetX, float offsetY, FontOptions options) {
        int color;
        VertexBuffer buffer = Tessellator.func_178181_a().func_178180_c();
        float factor = options.getFontScale() / this.fontGeneratorOptions.fontSize * 9.0f;
        float w = cd.getFullWidth(this.fontGeneratorOptions) * factor;
        float h = cd.getFullHeight(this.fontGeneratorOptions) / 9.0f * factor;
        int n = color = this.drawingShadow ? options.getShadowColor() : options.getColor();
        if (this.drawingShadow) {
            offsetX += options.getFontScale();
            offsetY += options.getFontScale();
        }
        buffer.func_181662_b((double)offsetX, (double)offsetY, 0.0);
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)offsetX, (double)(offsetY + h), 0.0);
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX + w), (double)(offsetY + h), 0.0);
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
        buffer.func_181662_b((double)(offsetX + w), (double)offsetY, 0.0);
        buffer.func_181669_b(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
        buffer.func_181675_d();
    }

    public String processString(String str, FontOptions options) {
        str = str.replaceAll("\r?\n", "");
        Pair<String, String> p = FontOptions.getStartFormat(str);
        return (String)p.getLeft() + this.translate((String)p.getRight());
    }

    private String translate(String str) {
        if (str.indexOf(123) == -1 || str.indexOf(123) >= str.indexOf(125)) {
            return I18n.func_135052_a((String)str, (Object[])new Object[0]);
        }
        StringBuffer output = new StringBuffer();
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            matcher.appendReplacement(output, I18n.func_135052_a((String)matcher.group(1), (Object[])new Object[0]));
        }
        matcher.appendTail(output);
        return output.toString();
    }

    private boolean hasLines(String text, FontOptions options) {
        return options.isUnderline() || options.isStrikethrough() || text.contains(TextFormatting.UNDERLINE.toString()) || text.contains(TextFormatting.STRIKETHROUGH.toString());
    }

    public String clipString(String str, int width) {
        return this.clipString(str, width, null, false);
    }

    public String clipString(String str, int width, FontOptions options) {
        return this.clipString(str, width, options, false);
    }

    public String clipString(String str, int width, FontOptions options, boolean appendPeriods) {
        str = this.processString(str, options);
        if (appendPeriods) {
            width -= 4;
        }
        int pos = (int)this.getCharPosition(str, options, width, 0);
        return str.substring(0, pos) + (pos < str.length() && appendPeriods ? "..." : "");
    }

    public float getStringWidth(String str) {
        return this.getStringWidth(str, null);
    }

    public float getStringWidth(String str, FontOptions options, int start, int end) {
        if (start > end) {
            return 0.0f;
        }
        if (options != null && !options.isFormattingDisabled()) {
            str = TextFormatting.func_110646_a((String)str);
        }
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        str = this.processString(str, options);
        return (float)this.font.getStringBounds(str, this.frc).getWidth() / this.fontGeneratorOptions.fontSize * (options != null ? options.getFontScale() : 1.0f) * 9.0f;
    }

    public float getStringWidth(String str, FontOptions options) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        return this.getStringWidth(str, options, 0, 0);
    }

    public float getStringHeight() {
        return this.getStringHeight(null);
    }

    public float getStringHeight(FontOptions options) {
        return (options != null ? options.getFontScale() : 1.0f) * 9.0f;
    }

    public float getMaxStringWidth(List<String> strings) {
        return this.getMaxStringWidth(strings, null);
    }

    public float getMaxStringWidth(List<String> strings, FontOptions options) {
        float width = 0.0f;
        for (String str : strings) {
            width = Math.max(width, this.getStringWidth(str, options));
        }
        return width;
    }

    public float getCharWidth(char c) {
        return this.getCharWidth(c, null);
    }

    public float getCharWidth(char c, FontOptions options) {
        if (c == '\r' || c == '\n') {
            return 0.0f;
        }
        if (c == '\t') {
            return this.getCharWidth(' ', options) * 4.0f;
        }
        return this.getCharData(c).getCharWidth() / this.fontGeneratorOptions.fontSize * (options != null ? options.getFontScale() : 1.0f) * 9.0f;
    }

    public float getCharPosition(String str, FontOptions options, int position, int charOffset) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0.0f;
        }
        str = this.processString(str, options);
        StringWalker walker = new StringWalker(str, this, options);
        walker.startIndex(charOffset);
        walker.skipChars(true);
        return walker.walkTo(position);
    }

    public List<String> wrapText(String text, int maxWidth) {
        return this.wrapText(text, maxWidth, null);
    }

    public List<String> wrapText(String str, int maxWidth, FontOptions options) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] texts = str.split("\r?(?<=\n)");
        if (texts.length > 1) {
            for (String t : texts) {
                lines.addAll(this.wrapText(t, maxWidth, options));
            }
            return lines;
        }
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        maxWidth -= 4;
        float lineWidth = 0.0f;
        float wordWidth = 0.0f;
        texts = (str = this.processString(str, options)).split("\\\\r?\\\\n");
        if (texts.length > 1) {
            for (String t : texts) {
                lines.addAll(this.wrapText(t, maxWidth, options));
            }
            return lines;
        }
        StringWalker walker = new StringWalker(str, this, options);
        walker.skipChars(false);
        walker.applyStyles(true);
        while (walker.walk()) {
            char c = walker.getChar();
            lineWidth += walker.getWidth();
            wordWidth += walker.getWidth();
            word.append(c);
            if (c == ' ' || c == '-' || c == '.') {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0.0f;
            }
            if (!(lineWidth >= (float)maxWidth)) continue;
            if (line.length() == 0) {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0.0f;
            }
            lines.add(line.toString());
            line.setLength(0);
            lineWidth = wordWidth;
        }
        line.append((CharSequence)word);
        lines.add(line.toString());
        return lines;
    }

    protected void loadCharacterData() {
        this.frc = new FontRenderContext(null, true, true);
        float totalWidth = 0.0f;
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            CharData cd;
            String s = "" + c;
            LineMetrics lm = this.font.getLineMetrics(s, this.frc);
            Rectangle2D bounds = this.font.getStringBounds(s, this.frc);
            this.charData[c] = cd = new CharData(c, lm.getAscent(), (float)bounds.getWidth(), this.fontGeneratorOptions.fontSize);
            totalWidth += cd.getFullWidth(this.fontGeneratorOptions);
        }
        int split = 1;
        while (totalWidth / (float)split > this.fontGeneratorOptions.fontSize * (float)split) {
            ++split;
        }
        this.size = this.roundUp((int)totalWidth / (split - 1));
    }

    protected int roundUp(int n) {
        int r = n - 1;
        r |= r >> 1;
        r |= r >> 2;
        r |= r >> 4;
        r |= r >> 8;
        r |= r >> 16;
        return r + 1;
    }

    protected void loadTexture(boolean forceGenerate) {
        BufferedImage img;
        File textureFile = new File("fonts/" + this.font.getName() + ".png");
        File uvFile = new File("fonts/" + this.font.getName() + ".bin");
        if (!textureFile.exists() || !uvFile.exists() || forceGenerate) {
            MalisisCore.log.info("Generating files for " + this.font.getName());
            img = new FontGenerator(this.font, this.charData, this.fontGeneratorOptions).generate(this.size, textureFile, uvFile);
        } else {
            MalisisCore.log.info("Loading texture and data for " + this.font.getName());
            img = this.readTextureFile(textureFile);
            this.readUVFile(uvFile);
        }
        if (img == null) {
            return;
        }
        if (this.textureRl != null) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(this.textureRl);
        }
        DynamicTexture dynTex = new DynamicTexture(img);
        this.textureRl = Minecraft.func_71410_x().func_110434_K().func_110578_a(this.font.getName(), dynTex);
    }

    protected BufferedImage readTextureFile(File textureFile) {
        try {
            BufferedImage img = ImageIO.read(textureFile);
            if (img == null) {
                MalisisCore.log.error("Failed to read font texture, no image could be read from the file.");
                return null;
            }
            this.size = img.getWidth();
            return img;
        }
        catch (IOException e) {
            MalisisCore.log.error("Failed to read font texture.", (Throwable)e);
            return null;
        }
    }

    protected void readUVFile(File uvFile) {
        int i = 0;
        try {
            for (String str : Files.readLines((File)uvFile, (Charset)StandardCharsets.UTF_8)) {
                String[] split = str.split(";");
                CharData cd = this.charData[i++];
                cd.setUVs(Float.parseFloat(split[1]), Float.parseFloat(split[2]), Float.parseFloat(split[3]), Float.parseFloat(split[4]));
            }
        }
        catch (IOException | NumberFormatException e) {
            MalisisCore.log.error("Failed to read font data. (Line " + i + " (" + (char)i + ")", (Throwable)e);
        }
    }

    public static Font load(ResourceLocation rl, FontGeneratorOptions options) {
        try {
            return MalisisFont.load(Minecraft.func_71410_x().func_110442_L().func_110536_a(rl).func_110527_b(), options);
        }
        catch (IOException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from ResourceLocation.", (Throwable)e);
            return null;
        }
    }

    public static Font load(File file, FontGeneratorOptions options) {
        try {
            return MalisisFont.load(new FileInputStream(file), options);
        }
        catch (FileNotFoundException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from File.", (Throwable)e);
            return null;
        }
    }

    public static Font load(InputStream is, FontGeneratorOptions options) {
        try {
            Font font = Font.createFont(options.fontType, is);
            return font.deriveFont(options.fontSize);
        }
        catch (FontFormatException | IOException e) {
            MalisisCore.log.error("[MalisiFont] Couldn't load font from InputStream.", (Throwable)e);
            return null;
        }
    }
}

