/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.InventoryState;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.core.util.ItemUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.ArrayUtils;

public interface ISidedInventoryProvider
extends IInventoryProvider.IDirectInventoryProvider,
ISidedInventory {
    public MalisisInventory getInventory(EnumFacing var1);

    default public MalisisInventory[] getInventories(EnumFacing side) {
        MalisisInventory[] malisisInventoryArray;
        if (this.getInventory(side) != null) {
            MalisisInventory[] malisisInventoryArray2 = new MalisisInventory[1];
            malisisInventoryArray = malisisInventoryArray2;
            malisisInventoryArray2[0] = this.getInventory(side);
        } else {
            malisisInventoryArray = null;
        }
        return malisisInventoryArray;
    }

    @Override
    default public MalisisInventory[] getInventories() {
        Object[] inventories = new MalisisInventory[]{};
        for (EnumFacing facing : EnumFacing.values()) {
            Object[] inv = this.getInventories(facing);
            if (ArrayUtils.isEmpty((Object[])inv)) continue;
            inventories = (MalisisInventory[])ArrayUtils.addAll((Object[])inventories, (Object[])inv);
        }
        return inventories;
    }

    default public EnumFacing getRealSide(EnumFacing side) {
        if (!(this instanceof TileEntity)) {
            return side;
        }
        IBlockState state = ((TileEntity)this).func_145831_w().func_180495_p(((TileEntity)this).func_174877_v());
        return EnumFacingUtils.getRealSide(state, side);
    }

    default public int convertSlotNumber(int slotNumber) {
        return slotNumber >> 3;
    }

    default public boolean isSlotInSide(int slotNumber, EnumFacing side) {
        return this.getInventory(slotNumber) == this.getInventory(side);
    }

    default public MalisisInventory getInventory(int slotNumber) {
        return this.getInventory(EnumFacing.func_82600_a((int)(slotNumber & 7)));
    }

    @Override
    default public ItemStack func_70301_a(int slotNumber) {
        return this.getInventory(slotNumber) != null ? this.getInventory(slotNumber).getItemStack(this.convertSlotNumber(slotNumber)) : null;
    }

    @Override
    default public ItemStack func_70298_a(int slotNumber, int count) {
        return this.getInventory(slotNumber) != null ? new ItemUtils.ItemStackSplitter(this.getInventory(slotNumber).getItemStack(this.convertSlotNumber(slotNumber))).split(count) : null;
    }

    @Override
    default public void func_70299_a(int slotNumber, ItemStack stack) {
        MalisisInventory inventory = this.getInventory(slotNumber);
        if (inventory != null) {
            inventory.setItemStack(this.convertSlotNumber(slotNumber), stack);
        }
    }

    @Override
    default public boolean func_94041_b(int slotNumber, ItemStack itemStack) {
        MalisisSlot slot = this.getInventory(slotNumber).getSlot(this.convertSlotNumber(slotNumber));
        return slot != null && slot.isItemValid(itemStack);
    }

    default public int[] func_180463_a(EnumFacing side) {
        MalisisInventory inventory = this.getInventory(side = this.getRealSide(side));
        if (inventory == null) {
            return new int[0];
        }
        int[] a = new int[inventory.getSizeInventory()];
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            a[i] = i << 3 | side.func_176745_a();
        }
        return a;
    }

    default public boolean func_180462_a(int slotNumber, ItemStack itemStack, EnumFacing side) {
        if (!this.isSlotInSide(slotNumber, side = this.getRealSide(side))) {
            return false;
        }
        MalisisInventory inventory = this.getInventory(side);
        if (inventory == null) {
            return false;
        }
        MalisisSlot slot = inventory.getSlot(this.convertSlotNumber(slotNumber));
        return slot != null && slot.state.is(InventoryState.AUTO_INSERT) && slot.isItemValid(itemStack);
    }

    default public boolean func_180461_b(int slotNumber, ItemStack itemStack, EnumFacing side) {
        if (!this.isSlotInSide(slotNumber, side = this.getRealSide(side))) {
            return false;
        }
        MalisisInventory inventory = this.getInventory(side);
        if (inventory == null) {
            return false;
        }
        MalisisSlot slot = inventory.getSlot(this.convertSlotNumber(slotNumber));
        return slot != null && slot.state.is(InventoryState.AUTO_EXTRACT);
    }
}

