/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.ISmartCull;
import net.malisis.core.block.component.DirectionalComponent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StairComponent
implements IBlockComponent,
ISmartCull {
    public static PropertyBool TOP = PropertyBool.func_177716_a((String)"top");

    public PropertyBool getProperty() {
        return TOP;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public List<IComponent> getDependencies() {
        return Lists.newArrayList((Object[])new IComponent[]{new DirectionalComponent()});
    }

    @Override
    public IBlockState getStateForPlacement(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack itemStack) {
        boolean top = facing == EnumFacing.DOWN || facing != EnumFacing.UP && hitY > 0.5f;
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(top));
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        return this.getBounds((IBlockAccess)(state.func_177230_c() == block ? world : null), pos, state).toArray(new AxisAlignedBB[0]);
    }

    public List<AxisAlignedBB> getBounds(IBlockAccess world, BlockPos pos, IBlockState state) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        list.add(this.getBaseBounds(world, pos, state));
        list.addAll(this.getStepBounds(world, pos, state));
        return list;
    }

    private AxisAlignedBB getBaseBounds(IBlockAccess world, BlockPos pos, IBlockState state) {
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        return StairComponent.isTop(state) ? aabb.func_72317_d(0.0, 0.5, 0.0) : aabb;
    }

    private boolean hasSameStairs(IBlockState state1, IBlockState state2) {
        return StairComponent.isStairs(state2.func_177230_c()) && StairComponent.getStairDirection(state1) == StairComponent.getStairDirection(state2) && StairComponent.isTop(state1) == StairComponent.isTop(state2);
    }

    private boolean shouldConnect(IBlockState state1, IBlockState state2, boolean hasLeftStairs, boolean hasRightStairs) {
        if (!StairComponent.isStairs(state2.func_177230_c())) {
            return false;
        }
        if (hasLeftStairs && hasRightStairs) {
            return false;
        }
        EnumFacing dir1 = StairComponent.getStairDirection(state1);
        EnumFacing dir2 = StairComponent.getStairDirection(state2);
        if (dir1.func_176740_k() == dir2.func_176740_k() || StairComponent.isTop(state1) != StairComponent.isTop(state2)) {
            return false;
        }
        if (dir1 == dir2.func_176746_e() && hasRightStairs) {
            return false;
        }
        return dir1 != dir2.func_176735_f() || !hasLeftStairs;
    }

    private List<AxisAlignedBB> getStepBounds(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (world == null) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0)});
        }
        EnumFacing dir = StairComponent.getStairDirection(state);
        boolean isTop = StairComponent.isTop(state);
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5);
        if (isTop) {
            aabb = aabb.func_72317_d(0.0, -0.5, 0.0);
        }
        boolean hasLeftStairs = this.hasSameStairs(state, world.func_180495_p(pos.func_177972_a(dir.func_176746_e())));
        boolean hasRightStairs = this.hasSameStairs(state, world.func_180495_p(pos.func_177972_a(dir.func_176735_f())));
        IBlockState stateOther = world.func_180495_p(pos.func_177972_a(dir.func_176734_d()));
        EnumFacing dirOther = StairComponent.getStairDirection(stateOther);
        if (this.shouldConnect(state, stateOther, hasLeftStairs, hasRightStairs)) {
            if (dirOther == dir.func_176746_e()) {
                return Lists.newArrayList((Object[])new AxisAlignedBB[]{aabb.func_72317_d(0.5, 0.0, 0.0)});
            }
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{aabb});
        }
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{aabb.func_72321_a(0.5, 0.0, 0.0)});
        stateOther = world.func_180495_p(pos.func_177972_a(dir));
        dirOther = StairComponent.getStairDirection(stateOther);
        if (this.shouldConnect(state, stateOther, hasRightStairs, hasLeftStairs)) {
            aabb = aabb.func_72317_d(0.0, 0.0, 0.5);
            if (dirOther == dir.func_176746_e()) {
                list.add(aabb.func_72317_d(0.5, 0.0, 0.0));
            } else {
                list.add(aabb);
            }
        }
        return list;
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return StairComponent.isTop(state) ? 8 : 0;
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return false;
    }

    public static boolean isStairs(Block block) {
        if (block instanceof BlockStairs) {
            return true;
        }
        return IComponent.getComponent(StairComponent.class, block) != null;
    }

    public static boolean isTop(IBlockAccess world, BlockPos pos) {
        return world != null ? StairComponent.isTop(world.func_180495_p(pos)) : false;
    }

    public static boolean isTop(IBlockState state) {
        StairComponent sc = IComponent.getComponent(StairComponent.class, state.func_177230_c());
        if (sc == null) {
            return false;
        }
        PropertyBool property = sc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)property);
    }

    public static EnumFacing getStairDirection(IBlockState state) {
        if (!StairComponent.isStairs(state.func_177230_c())) {
            return null;
        }
        if (state.func_177230_c() instanceof BlockStairs) {
            return ((EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176734_d();
        }
        return DirectionalComponent.getDirection(state);
    }
}

