/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gearswap.proxy;

import mcjty.gearswap.Config;
import mcjty.gearswap.GearSwap;
import mcjty.gearswap.ModCrafting;
import mcjty.gearswap.blocks.ModBlocks;
import mcjty.gearswap.items.ModItems;
import mcjty.gearswap.network.PacketHandler;
import mcjty.gearswap.proxy.GuiProxy;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy {
    private Configuration mainConfig;

    public void preInit(FMLPreInitializationEvent e) {
        this.mainConfig = GearSwap.config;
        this.readMainConfig();
        ModItems.init();
        ModBlocks.init();
        ModCrafting.init();
        PacketHandler.registerMessages("gearswapper");
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment(Config.CATEGORY_GEARSWAP, "General configuration");
            cfg.addCustomCategoryComment(Config.CATEGORY_RULES, "Rules that help decide if two items are considered equal. Every rule contains a list of tags that have to match");
            Config.init(cfg);
        }
        catch (Exception e1) {
            GearSwap.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)GearSwap.instance, (IGuiHandler)new GuiProxy());
    }

    public void postInit(FMLPostInitializationEvent e) {
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        this.mainConfig = null;
    }
}

