/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gearswap.blocks;

import javax.annotation.Nullable;
import mcjty.gearswap.Config;
import mcjty.gearswap.GearSwap;
import mcjty.gearswap.blocks.ExternalInventorySource;
import mcjty.gearswap.blocks.InternalSource;
import mcjty.gearswap.blocks.OriginalStackSource;
import mcjty.gearswap.blocks.PlayerSource;
import mcjty.gearswap.blocks.Source;
import mcjty.gearswap.items.ModItems;
import mcjty.gearswap.varia.InventoryHelper;
import mcjty.gearswap.varia.Tools;
import mcjty.lib.compat.CompatSidedInventory;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.WorldTools;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GearSwapperTE
extends TileEntity
implements CompatSidedInventory {
    private ItemStack[] stacks = new ItemStack[96];
    public static final int SLOT_GHOST = 4;
    public static final int SLOT_BUFFER = 60;
    public static final int SLOT_BAUBLES = 76;
    public static final int SLOT_GHOSTSHIELD = 92;
    public static final int MODE_PLAYERINV = 0;
    public static final int MODE_LOCALINV = 1;
    public static final int MODE_REMOTEINV = 2;
    private int[] exportModes = new int[]{0, 1, 2};
    IItemHandler invHandler = new InvWrapper((IInventory)this);

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        this.readBufferFromNBT(tagCompound);
        this.exportModes[0] = tagCompound.func_74762_e("export0");
        this.exportModes[1] = tagCompound.func_74762_e("export1");
        this.exportModes[2] = tagCompound.func_74762_e("export2");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.setStackInSlot(i, ItemStackTools.loadFromNBT((NBTTagCompound)nbtTagCompound));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.writeRestorableToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("export0", this.exportModes[0]);
        tagCompound.func_74768_a("export1", this.exportModes[1]);
        tagCompound.func_74768_a("export2", this.exportModes[2]);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            ItemStack stack = this.func_70301_a(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (ItemStackTools.isValid((ItemStack)stack)) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public int getExportMode(int i) {
        return this.exportModes[i];
    }

    public void toggelExportMode(int i) {
        int n = i;
        this.exportModes[n] = this.exportModes[n] + 1;
        if (this.exportModes[i] > 2) {
            this.exportModes[i] = 0;
        }
        this.func_70296_d();
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void setFaceIconSlot(int index, ItemStack stack) {
        this.func_70299_a(index, stack);
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    private int getPlayerInventorySize() {
        if (GearSwap.baubles) {
            return 18;
        }
        return 14;
    }

    private int getInventoryIndex(int i) {
        if (i < 9) {
            return i;
        }
        if (i == 13) {
            return 40;
        }
        return i - 9 + 36;
    }

    private ItemStack getStackFromPlayerInventory(int index, EntityPlayer player) {
        IInventory baubles;
        if (index < 14) {
            return player.field_71071_by.func_70301_a(this.getInventoryIndex(index));
        }
        if (GearSwap.baubles && (baubles = Tools.getBaubles(player)) != null) {
            return baubles.func_70301_a(index - 14);
        }
        return ItemStackTools.getEmptyStack();
    }

    private void putStackInPlayerInventory(int index, EntityPlayer player, ItemStack stack) {
        IInventory baubles;
        if (index < 14) {
            player.field_71071_by.func_70299_a(this.getInventoryIndex(index), stack);
        } else if (GearSwap.baubles && (baubles = Tools.getBaubles(player)) != null) {
            baubles.func_70299_a(index - 14, stack);
        }
    }

    private int getInternalInventoryIndex(int index, int i) {
        if (i >= 14) {
            return 76 + index * 4 + (i - 14);
        }
        return 4 + index * 14 + i;
    }

    public void rememberSetup(int index, EntityPlayer player) {
        this.setFaceIconSlot(index, player.func_184586_b(EnumHand.MAIN_HAND));
        for (int i = 0; i < this.getPlayerInventorySize(); ++i) {
            ItemStack stack = this.getStackFromPlayerInventory(i, player);
            if (ItemStackTools.isValid((ItemStack)stack) && ItemStackTools.getStackSize((ItemStack)stack) == 0) {
                stack = ItemStackTools.safeCopy((ItemStack)stack);
            }
            this.func_70299_a(this.getInternalInventoryIndex(index, i), stack);
        }
    }

    public void restoreSetup(int index, EntityPlayer player) {
        ItemStack stack;
        int i;
        InventoryPlayer inventory = player.field_71071_by;
        ItemStack[] currentStacks = new ItemStack[this.getPlayerInventorySize()];
        for (i = 0; i < this.getPlayerInventorySize(); ++i) {
            currentStacks[i] = this.getStackFromPlayerInventory(i, player);
            this.putStackInPlayerInventory(i, player, new ItemStack((Item)ModItems.forceEmptyItem));
        }
        for (i = 0; i < this.getPlayerInventorySize(); ++i) {
            ItemStack desiredStack = this.func_70301_a(this.getInternalInventoryIndex(index, i));
            if (ItemStackTools.isEmpty((ItemStack)desiredStack) || desiredStack.func_77973_b() == ModItems.forceEmptyItem) continue;
            ItemStack foundStack = this.findBestMatchingStack(desiredStack, currentStacks, inventory);
            this.putStackInPlayerInventory(i, player, foundStack);
        }
        for (i = 0; i < this.getPlayerInventorySize(); ++i) {
            int internalInventoryIndex;
            ItemStack desiredStack;
            stack = this.getStackFromPlayerInventory(i, player);
            if (!ItemStackTools.isEmpty((ItemStack)stack) && stack.func_77973_b() != ModItems.forceEmptyItem || !ItemStackTools.isValid((ItemStack)currentStacks[i]) || currentStacks[i].func_77973_b() == ModItems.forceEmptyItem || !ItemStackTools.isEmpty((ItemStack)(desiredStack = this.func_70301_a(internalInventoryIndex = this.getInternalInventoryIndex(index, i)))) && desiredStack.func_77973_b() == ModItems.forceEmptyItem) continue;
            this.putStackInPlayerInventory(i, player, currentStacks[i]);
            currentStacks[i] = ItemStackTools.getEmptyStack();
        }
        for (i = 0; i < this.getPlayerInventorySize(); ++i) {
            if (!ItemStackTools.isValid((ItemStack)currentStacks[i]) || !this.storeItem(inventory, currentStacks[i])) continue;
            currentStacks[i] = ItemStackTools.getEmptyStack();
        }
        for (i = 0; i < this.getPlayerInventorySize(); ++i) {
            stack = this.getStackFromPlayerInventory(i, player);
            if (!ItemStackTools.isValid((ItemStack)stack) || stack.func_77973_b() != ModItems.forceEmptyItem) continue;
            this.putStackInPlayerInventory(i, player, ItemStackTools.getEmptyStack());
        }
        for (i = 0; i < this.getPlayerInventorySize(); ++i) {
            if (!ItemStackTools.isValid((ItemStack)currentStacks[i]) || !inventory.func_70441_a(currentStacks[i])) continue;
            currentStacks[i] = ItemStackTools.getEmptyStack();
        }
        for (i = 0; i < this.getPlayerInventorySize(); ++i) {
            if (!ItemStackTools.isValid((ItemStack)currentStacks[i])) continue;
            EntityItem entityItem = new EntityItem(this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), currentStacks[i]);
            WorldTools.spawnEntity((World)this.func_145831_w(), (Entity)entityItem);
        }
        this.func_70296_d();
        player.field_71070_bA.func_75142_b();
    }

    private boolean storeItem(InventoryPlayer inventory, ItemStack item) {
        block5: for (int exportMode : this.exportModes) {
            switch (exportMode) {
                case 0: {
                    if (!inventory.func_70441_a(item)) continue block5;
                    return true;
                }
                case 1: {
                    int left = InventoryHelper.mergeItemStack((IInventory)this, item, 60, 76, null);
                    if (left == 0) {
                        return true;
                    }
                    ItemStackTools.setStackSize((ItemStack)item, (int)left);
                    continue block5;
                }
                case 2: {
                    for (EnumFacing facing : EnumFacing.values()) {
                        TileEntity te = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
                        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                            IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                            ItemStack stack = ItemHandlerHelper.insertItem((IItemHandler)capability, (ItemStack)item, (boolean)false);
                            if (ItemStackTools.isEmpty((ItemStack)stack)) {
                                return true;
                            }
                            item = stack;
                            continue;
                        }
                        if (!(te instanceof IInventory)) continue;
                        IInventory otherInventory = (IInventory)te;
                        int left = InventoryHelper.mergeItemStackSafe(otherInventory, facing.func_176734_d(), item, 0, otherInventory.func_70302_i_(), null);
                        if (left == 0) {
                            return true;
                        }
                        ItemStackTools.setStackSize((ItemStack)item, (int)left);
                    }
                    continue block5;
                }
            }
        }
        return false;
    }

    private ItemStack findBestMatchingStack(ItemStack desired, ItemStack[] currentStacks, InventoryPlayer inventoryPlayer) {
        ItemStack bestSoFar = ItemStackTools.getEmptyStack();
        desired = ItemStackTools.safeCopy((ItemStack)desired);
        while (ItemStackTools.isValid((ItemStack)desired)) {
            ItemStack stack = this.findBestMatchingStackWithScore(desired, currentStacks, inventoryPlayer, bestSoFar);
            if (ItemStackTools.isEmpty((ItemStack)stack)) {
                return bestSoFar;
            }
            if (ItemStackTools.isValid((ItemStack)bestSoFar)) {
                ItemStackTools.incStackSize((ItemStack)bestSoFar, (int)ItemStackTools.getStackSize((ItemStack)stack));
            } else {
                bestSoFar = stack;
            }
            ItemStackTools.incStackSize((ItemStack)desired, (int)(-ItemStackTools.getStackSize((ItemStack)stack)));
        }
        return bestSoFar;
    }

    private void findBestMatchingStackWithScore(ItemStack desired, Source source, BestScore bestScore, ItemStack bestMatch) {
        for (int i = 0; i < source.getStackCount(); ++i) {
            int score;
            ItemStack current = source.getStack(i);
            if (ItemStackTools.isValid((ItemStack)bestMatch) && ItemStackTools.isValid((ItemStack)current) && (!bestMatch.func_77969_a(current) || !ItemStack.func_77970_a((ItemStack)bestMatch, (ItemStack)current)) || (score = this.calculateMatchingScore(desired, current)) <= bestScore.score) continue;
            bestScore.score = score;
            bestScore.source = source;
            bestScore.index = i;
        }
    }

    private ItemStack findBestMatchingStackWithScore(ItemStack desired, ItemStack[] currentStacks, InventoryPlayer inventoryPlayer, ItemStack bestMatch) {
        BestScore bestScore = new BestScore();
        this.findBestMatchingStackWithScore(desired, new OriginalStackSource(currentStacks), bestScore, bestMatch);
        this.findBestMatchingStackWithScore(desired, new PlayerSource(inventoryPlayer), bestScore, bestMatch);
        this.findBestMatchingStackWithScore(desired, new InternalSource(this), bestScore, bestMatch);
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity te = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (!(te instanceof IInventory)) continue;
            this.findBestMatchingStackWithScore(desired, new ExternalInventorySource((IInventory)te, facing), bestScore, bestMatch);
        }
        if (bestScore.source != null) {
            return bestScore.source.extractAmount(bestScore.index, ItemStackTools.getStackSize((ItemStack)desired));
        }
        return ItemStackTools.getEmptyStack();
    }

    private int calculateMatchingScore(ItemStack desired, ItemStack current) {
        if (ItemStackTools.isEmpty((ItemStack)current)) {
            return -1;
        }
        if (ItemStack.func_77970_a((ItemStack)desired, (ItemStack)current) && desired.func_77969_a(current)) {
            return 1000;
        }
        if (desired.func_77973_b().equals(current.func_77973_b()) && desired.func_77978_p() != null && current.func_77978_p() != null && this.itemsMatchForSpecificTags(desired, current)) {
            return 700;
        }
        if (desired.func_77969_a(current)) {
            return 500;
        }
        if (desired.func_77973_b().equals(current.func_77973_b())) {
            return 200;
        }
        return -1;
    }

    private boolean itemsMatchForSpecificTags(ItemStack desired, ItemStack current) {
        if (Config.tagsThatHaveToMatch.containsKey(desired.func_77977_a())) {
            String[] tags = Config.tagsThatHaveToMatch.get(desired.func_77977_a());
            boolean ok = true;
            for (String tag : tags) {
                NBTBase tag1 = desired.func_77978_p().func_74781_a(tag);
                NBTBase tag2 = current.func_77978_p().func_74781_a(tag);
                if (tag1 == null && tag2 != null) {
                    ok = false;
                    break;
                }
                if (tag1 != null && tag2 == null) {
                    ok = false;
                    break;
                }
                if (tag1 == null || tag1.equals((Object)tag2)) continue;
                ok = false;
                break;
            }
            if (ok) {
                return true;
            }
        }
        return false;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.stacks.length;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= this.stacks.length) {
            return ItemStackTools.getEmptyStack();
        }
        return this.stacks[index];
    }

    public boolean isGhostSlot(int index) {
        return index >= 0 && index < 60 || GearSwap.baubles && index >= 76 && index < 92;
    }

    public boolean isIconSlot(int index) {
        return index >= 0 && index < 4;
    }

    public boolean isBufferSlot(int index) {
        return index >= 60 && index < 76;
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (index >= this.stacks.length) {
            return ItemStackTools.getEmptyStack();
        }
        if (this.isGhostSlot(index)) {
            ItemStack old = this.stacks[index];
            this.stacks[index] = ItemStackTools.getEmptyStack();
            if (ItemStackTools.isEmpty((ItemStack)old)) {
                return ItemStackTools.getEmptyStack();
            }
            return ItemStackTools.setStackSize((ItemStack)old, (int)0);
        }
        if (ItemStackTools.isValid((ItemStack)this.stacks[index])) {
            if (ItemStackTools.getStackSize((ItemStack)this.stacks[index]) <= amount) {
                ItemStack old = this.stacks[index];
                this.stacks[index] = ItemStackTools.getEmptyStack();
                this.func_70296_d();
                return old;
            }
            ItemStack its = this.stacks[index].func_77979_a(amount);
            if (ItemStackTools.isEmpty((ItemStack)this.stacks[index])) {
                this.stacks[index] = ItemStackTools.getEmptyStack();
            }
            this.func_70296_d();
            return its;
        }
        return ItemStackTools.getEmptyStack();
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (index >= this.stacks.length) {
            return;
        }
        this.stacks[index] = stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= this.stacks.length) {
            return;
        }
        if (this.isGhostSlot(index)) {
            this.stacks[index] = ItemStackTools.isValid((ItemStack)stack) ? stack.func_77946_l() : ItemStackTools.getEmptyStack();
        } else {
            this.stacks[index] = stack;
            if (ItemStackTools.isValid((ItemStack)stack) && ItemStackTools.getStackSize((ItemStack)stack) > this.func_70297_j_()) {
                ItemStackTools.setStackSize((ItemStack)stack, (int)this.func_70297_j_());
            }
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isUsable(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !this.isGhostSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= 60;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index >= 60;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackTools.getEmptyStack();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.invHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    private class BestScore {
        public int score = -1;
        public Source source = null;
        public int index = -1;

        private BestScore() {
        }
    }
}

