/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gearswap;

import java.io.File;
import mcjty.gearswap.Config;
import mcjty.gearswap.blocks.ModBlocks;
import mcjty.gearswap.compat.MainCompatHandler;
import mcjty.gearswap.items.ModItems;
import mcjty.gearswap.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="gearswap", name="Gear Swapper", dependencies="required-after:compatlayer@[0.1.7,);after:Forge@[11.15.0.1600,);after:forge@[13.19.0.2176,)", acceptedMinecraftVersions="[1.9,1.12)", version="1.4.1")
public class GearSwap {
    public static final String MODID = "gearswap";
    public static final String VERSION = "1.4.1";
    public static final String MIN_FORGE10_VER = "11.15.0.1600";
    public static final String MIN_FORGE11_VER = "13.19.0.2176";
    public static final String COMPATLAYER_VER = "0.1.7";
    @SidedProxy(clientSide="mcjty.gearswap.proxy.ClientProxy", serverSide="mcjty.gearswap.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="gearswap")
    public static GearSwap instance;
    public static Logger logger;
    public static File mainConfigDir;
    public static File modConfigDir;
    public static Configuration config;
    public static int GUI_GEARSWAP;
    public static boolean baubles;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        mainConfigDir = e.getModConfigurationDirectory();
        modConfigDir = new File(mainConfigDir.getPath());
        config = new Configuration(new File(modConfigDir, "gearswap.cfg"));
        proxy.preInit(e);
        MainCompatHandler.registerWaila();
        MainCompatHandler.registerTOP();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
        baubles = Loader.isModLoaded((String)"Baubles");
        if (baubles) {
            if (Config.supportBaubles) {
                logger.log(Level.INFO, "Gear Swapper Detected Baubles: enabling support");
            } else {
                logger.log(Level.INFO, "Gear Swapper Detected Baubles but it is disabled in config anyway: disabling support");
                baubles = false;
            }
        }
    }

    @Mod.EventHandler
    public void onMissingMapping(FMLMissingMappingsEvent event) {
        logger.info("Repairing missing mappings");
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            String resourcePath = mapping.resourceLocation.func_110623_a().toLowerCase();
            if (mapping.type == GameRegistry.Type.BLOCK) {
                if ("gearswapperglass".equals(resourcePath)) {
                    mapping.remap((Block)ModBlocks.glassGearSwapperBlock);
                    continue;
                }
                if ("gearswapperiron".equals(resourcePath)) {
                    mapping.remap((Block)ModBlocks.ironGearSwapperBlock);
                    continue;
                }
                if ("gearswapperlapis".equals(resourcePath)) {
                    mapping.remap((Block)ModBlocks.lapisGearSwapperBlock);
                    continue;
                }
                if ("gearswapperstone".equals(resourcePath)) {
                    mapping.remap((Block)ModBlocks.stoneGearSwapperBlock);
                    continue;
                }
                if (!"gearswapperwood".equals(resourcePath)) continue;
                mapping.remap((Block)ModBlocks.woodenGearSwapperBlock);
                continue;
            }
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            if ("emptyitem".equals(resourcePath)) {
                mapping.remap((Item)ModItems.forceEmptyItem);
                continue;
            }
            if ("gearswapperglass".equals(resourcePath)) {
                mapping.remap(Item.func_150898_a((Block)ModBlocks.glassGearSwapperBlock));
                continue;
            }
            if ("gearswapperiron".equals(resourcePath)) {
                mapping.remap(Item.func_150898_a((Block)ModBlocks.ironGearSwapperBlock));
                continue;
            }
            if ("gearswapperlapis".equals(resourcePath)) {
                mapping.remap(Item.func_150898_a((Block)ModBlocks.lapisGearSwapperBlock));
                continue;
            }
            if ("gearswapperstone".equals(resourcePath)) {
                mapping.remap(Item.func_150898_a((Block)ModBlocks.stoneGearSwapperBlock));
                continue;
            }
            if (!"gearswapperwood".equals(resourcePath)) continue;
            mapping.remap(Item.func_150898_a((Block)ModBlocks.woodenGearSwapperBlock));
        }
    }

    static {
        GUI_GEARSWAP = 0;
        baubles = false;
    }
}

