/*
 * Decompiled with CFR 0.152.
 */
package magma_monsters.entities;

import java.util.Random;
import magma_monsters.MagmaMonsters;
import magma_monsters.configs.ConfigHandler;
import magma_monsters.network.QuenchMessage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMagmaMonster
extends EntityMob {
    private static final DataParameter<Boolean> IS_MOLTEN = EntityDataManager.func_187226_a(EntityMagmaMonster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MOLTEN_TIMER = EntityDataManager.func_187226_a(EntityMagmaMonster.class, (DataSerializer)DataSerializers.field_187192_b);
    protected AIFireballAttack aiFireballAttack;

    public EntityMagmaMonster(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.75f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_MOLTEN, (Object)true);
        this.field_70180_af.func_187214_a(MOLTEN_TIMER, (Object)50);
    }

    public void setMolten(boolean molten) {
        this.field_70180_af.func_187227_b(IS_MOLTEN, (Object)molten);
    }

    public boolean getMolten() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MOLTEN);
    }

    public void setMoltenTimer(int moltenTimer) {
        this.field_70180_af.func_187227_b(MOLTEN_TIMER, (Object)moltenTimer);
    }

    public int getMoltenTimer() {
        return (Integer)this.field_70180_af.func_187225_a(MOLTEN_TIMER);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("molten", this.getMolten());
        nbt.func_74768_a("molten_timer", this.getMoltenTimer());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(IS_MOLTEN, (Object)nbt.func_74767_n("molten"));
        this.field_70180_af.func_187227_b(MOLTEN_TIMER, (Object)nbt.func_74762_e("molten_timer"));
    }

    protected void func_184651_r() {
        this.aiFireballAttack = new AIFireballAttack(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiFireballAttack);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIMonsterAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)ConfigHandler.MAGMA_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ConfigHandler.MAGMA_HEALTH);
    }

    public boolean func_70601_bi() {
        return this.getCanSpawnInLava() && this.field_70163_u <= (double)ConfigHandler.MAGMA_SPAWN_Y_HEIGHT;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean getCanSpawnInLava() {
        return this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v)).func_185904_a() == Material.field_151587_i;
    }

    protected SoundEvent func_184639_G() {
        return MagmaMonsters.MAGMA_MONSTER_LIVING;
    }

    protected SoundEvent func_184601_bQ() {
        return MagmaMonsters.MAGMA_MONSTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MagmaMonsters.MAGMA_MONSTER_DEATH;
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int randomAmount = 1 + this.field_70146_Z.nextInt(2 + looting);
        for (int count = 0; count < randomAmount; ++count) {
            if (this.getMolten()) {
                this.func_70099_a(new ItemStack(this.field_70146_Z.nextBoolean() ? Items.field_151065_br : Items.field_151064_bs), 0.0f);
                continue;
            }
            this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150343_Z)), 0.0f);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70170_p.func_72820_D() % 10L == 0L && this.getMolten()) {
            this.lavaParticles(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.3, this.field_70161_v, this.field_70146_Z);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getMolten() && this.getMoltenTimer() < 50) {
                this.setMoltenTimer(this.getMoltenTimer() + 1);
            }
            if (!this.getMolten() && this.getMoltenTimer() > 0) {
                this.setMoltenTimer(this.getMoltenTimer() - 1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void lavaParticles(World world, double x, double y, double z, Random rand) {
        MagmaMonsters.PROXY.spawnCustomParticle("lava", this.field_70170_p, x, y, z, 0.0, 0.0, 0.0);
    }

    public void changeParticles(Entity entity, float x, float y, float z, byte type) {
        for (EntityPlayer playersNear : entity.field_70170_p.field_73010_i) {
            if (!(playersNear.func_70068_e(entity) < 1024.0)) continue;
            MagmaMonsters.NETWORK_WRAPPER.sendTo((IMessage)new QuenchMessage(x, y, z, type), (EntityPlayerMP)playersNear);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70026_G() && !this.func_180799_ab() && this.getMolten()) {
                this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187659_cY, SoundCategory.HOSTILE, 1.0f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
                this.changeParticles((Entity)this, (float)this.field_70165_t, (float)this.field_70163_u + 0.9f, (float)this.field_70161_v, (byte)0);
                this.setMolten(false);
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
            }
            if (this.func_180799_ab() && !this.getMolten()) {
                this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187616_bj, SoundCategory.HOSTILE, 1.0f, 0.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
                this.changeParticles((Entity)this, (float)this.field_70165_t, (float)this.field_70163_u + 0.9f, (float)this.field_70161_v, (byte)1);
                this.setMolten(true);
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            }
            if (this.field_70146_Z.nextInt(40) == 0 && ConfigHandler.MAGMA_BLOCK_FIRE && this.getMolten()) {
                int i = MathHelper.func_76128_c((double)this.field_70165_t);
                int j = MathHelper.func_76128_c((double)this.field_70163_u);
                int k = MathHelper.func_76128_c((double)this.field_70161_v);
                for (int l = 0; l < 4; ++l) {
                    i = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                    BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                    if (this.field_70170_p.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a || !Blocks.field_150480_ab.func_176196_c(this.field_70170_p, blockpos)) continue;
                    this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            int duration;
            int modifier = !this.getMolten() ? 2 : 1;
            boolean hasHitTarget = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * modifier));
            if (hasHitTarget && entity instanceof EntityLivingBase && !this.getMolten() && (duration = ConfigHandler.SLOWNESS_EFFECT_DURATION) > 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration * 20, 0));
            }
            return hasHitTarget;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source instanceof EntityDamageSourceIndirect && !this.getMolten()) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187837_fU, SoundCategory.HOSTILE, 2.5f, 3.0f);
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    static class AIFireballAttack
    extends EntityAIBase {
        private final EntityMagmaMonster magma_monster;
        private int attackStep;
        private int attackTime;

        public AIFireballAttack(EntityMagmaMonster magma_monsterIn) {
            this.magma_monster = magma_monsterIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.magma_monster.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S() && this.magma_monster.getMolten();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.magma_monster.func_70638_az();
            double d0 = this.magma_monster.func_70068_e((Entity)entitylivingbase);
            if (d0 < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.magma_monster.func_70652_k((Entity)entitylivingbase);
                }
                this.magma_monster.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            } else if (d0 < 256.0 && this.magma_monster.getMolten()) {
                double d1 = entitylivingbase.field_70165_t - this.magma_monster.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (this.magma_monster.field_70163_u + (double)(this.magma_monster.field_70131_O / 2.0f));
                double d3 = entitylivingbase.field_70161_v - this.magma_monster.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1) {
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        this.magma_monster.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.magma_monster.field_70165_t, (int)this.magma_monster.field_70163_u, (int)this.magma_monster.field_70161_v), 0);
                        for (int i = 0; i < 1; ++i) {
                            EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.magma_monster.field_70170_p, (EntityLivingBase)this.magma_monster, d1 + this.magma_monster.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.magma_monster.func_70681_au().nextGaussian() * (double)f);
                            entitysmallfireball.field_70163_u = this.magma_monster.field_70163_u + (double)(this.magma_monster.field_70131_O / 2.0f) + 0.5;
                            this.magma_monster.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                        }
                    }
                }
                this.magma_monster.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
                this.magma_monster.func_70661_as().func_75499_g();
                this.magma_monster.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, 1.0);
            }
            super.func_75246_d();
        }
    }

    static class AIMonsterAttack
    extends EntityAIAttackMelee {
        public AIMonsterAttack(EntityMagmaMonster magma_monster) {
            super((EntityCreature)magma_monster, 1.0, false);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

