/*
 * Decompiled with CFR 0.152.
 */
package magma_monsters;

import magma_monsters.configs.ConfigHandler;
import magma_monsters.entities.EntityMagmaMonster;
import magma_monsters.entities.EntityMagmaMonsterGrunt;
import magma_monsters.network.QuenchMessage;
import magma_monsters.network.QuenchPacketHandler;
import magma_monsters.proxy.CommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="magma_monsters", name="magma_monsters", version="0.1.15", guiFactory="magma_monsters.configs.ConfigGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class MagmaMonsters {
    static int startEntityId = 1;
    @Mod.Instance(value="magma_monsters")
    public static MagmaMonsters INSTANCE;
    @SidedProxy(clientSide="magma_monsters.proxy.ClientProxy", serverSide="magma_monsters.proxy.CommonProxy")
    public static CommonProxy PROXY;
    public static SoundEvent MAGMA_MONSTER_LIVING;
    public static SoundEvent MAGMA_MONSTER_HURT;
    public static SoundEvent MAGMA_MONSTER_DEATH;
    public static SimpleNetworkWrapper NETWORK_WRAPPER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.INSTANCE.loadConfig(event);
        EntityRegistry.registerModEntity(EntityMagmaMonster.class, (String)"MagmaMonster", (int)1, (Object)this, (int)120, (int)1, (boolean)true);
        EntitySpawnPlacementRegistry.setPlacementType(EntityMagmaMonster.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MagmaMonsters.registerEntityEgg(EntityMagmaMonster.class, 0xFF0000, 440576);
        EntityRegistry.registerModEntity(EntityMagmaMonsterGrunt.class, (String)"MagmaMonsterGrunt", (int)2, (Object)this, (int)120, (int)1, (boolean)true);
        EntitySpawnPlacementRegistry.setPlacementType(EntityMagmaMonsterGrunt.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
        MagmaMonsters.registerEntityEgg(EntityMagmaMonsterGrunt.class, 0xFF0000, 440576);
        PROXY.registerRenderers();
        for (Biome allBiomes : ForgeRegistries.BIOMES.getValues()) {
            if (!BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && !BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                if (ConfigHandler.MAGMA_OW_SPAWN) {
                    EntityRegistry.addSpawn(EntityMagmaMonster.class, (int)ConfigHandler.MAGMA_OW_SPAWN_PROBABILITY, (int)ConfigHandler.MAGMA_OW_MIN_SPAWN_SIZE, (int)ConfigHandler.MAGMA_OW_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
                }
                if (ConfigHandler.MAGMA_GRUNT_OW_SPAWN) {
                    EntityRegistry.addSpawn(EntityMagmaMonsterGrunt.class, (int)ConfigHandler.MAGMA_GRUNT_OW_SPAWN_PROBABILITY, (int)ConfigHandler.MAGMA_GRUNT_OW_MIN_SPAWN_SIZE, (int)ConfigHandler.MAGMA_GRUNT_OW_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
                }
            }
            if (!BiomeDictionary.isBiomeOfType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
            if (ConfigHandler.MAGMA_HELL_SPAWN) {
                EntityRegistry.addSpawn(EntityMagmaMonster.class, (int)ConfigHandler.MAGMA_HELL_SPAWN_PROBABILITY, (int)ConfigHandler.MAGMA_HELL_MIN_SPAWN_SIZE, (int)ConfigHandler.MAGMA_HELL_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
            }
            if (!ConfigHandler.MAGMA_GRUNT_HELL_SPAWN) continue;
            EntityRegistry.addSpawn(EntityMagmaMonsterGrunt.class, (int)ConfigHandler.MAGMA_GRUNT_HELL_SPAWN_PROBABILITY, (int)ConfigHandler.MAGMA_GRUNT_HELL_MIN_SPAWN_SIZE, (int)ConfigHandler.MAGMA_GRUNT_HELL_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
        }
    }

    public static int getUniqueEntityId() {
        while (EntityList.func_90035_a((int)(++startEntityId)) != null) {
        }
        return startEntityId;
    }

    public static void registerEntityEgg(Class<? extends Entity> entity, int primaryColor, int secondaryColor) {
        int id = MagmaMonsters.getUniqueEntityId();
        EntityList.func_75618_a(entity, (String)entity.getName(), (int)id);
        EntityList.field_75627_a.put(entity.getName(), new EntityList.EntityEggInfo(entity.getName(), primaryColor, secondaryColor));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MAGMA_MONSTER_LIVING = (SoundEvent)new SoundEvent(new ResourceLocation("magma_monsters", "magma_monster_living")).setRegistryName("magma_monsters", "magma_monster_living");
        GameRegistry.register((IForgeRegistryEntry)MAGMA_MONSTER_LIVING);
        MAGMA_MONSTER_HURT = (SoundEvent)new SoundEvent(new ResourceLocation("magma_monsters", "magma_monster_hurt")).setRegistryName("magma_monsters", "magma_monster_hurt");
        GameRegistry.register((IForgeRegistryEntry)MAGMA_MONSTER_HURT);
        MAGMA_MONSTER_DEATH = (SoundEvent)new SoundEvent(new ResourceLocation("magma_monsters", "magma_monster_death")).setRegistryName("magma_monsters", "magma_monster_death");
        GameRegistry.register((IForgeRegistryEntry)MAGMA_MONSTER_DEATH);
        MinecraftForge.EVENT_BUS.register((Object)ConfigHandler.INSTANCE);
        NETWORK_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("magma_monsters");
        NETWORK_WRAPPER.registerMessage(QuenchPacketHandler.class, QuenchMessage.class, 0, Side.CLIENT);
    }
}

