/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.proxy;

import mcjty.lib.tools.MinecraftTools;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.commands.CommandTopCfg;
import mcjty.theoneprobe.commands.CommandTopNeed;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.gui.GuiConfig;
import mcjty.theoneprobe.gui.GuiNote;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.keys.KeyBindings;
import mcjty.theoneprobe.keys.KeyInputHandler;
import mcjty.theoneprobe.proxy.CommonProxy;
import mcjty.theoneprobe.rendering.OverlayRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public static boolean ignoreNextGuiClose = false;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        ModItems.initClient();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTopCfg());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandTopNeed());
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        KeyBindings.init();
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (ignoreNextGuiClose) {
            GuiScreen current = Minecraft.func_71410_x().field_71462_r;
            if (event.getGui() == null && (current instanceof GuiConfig || current instanceof GuiNote)) {
                ignoreNextGuiClose = false;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void renderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if (Config.holdKeyToMakeVisible ? !KeyBindings.toggleVisible.func_151470_d() : !Config.isVisible) {
            return;
        }
        if (this.hasItemInEitherHand(ModItems.creativeProbe)) {
            OverlayRenderer.renderHUD(ProbeMode.DEBUG, event.getPartialTicks());
        } else {
            switch (Config.needsProbe) {
                case 0: 
                case 3: {
                    OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getPartialTicks());
                    break;
                }
                case 1: 
                case 2: {
                    if (!ModItems.hasAProbeSomewhere((EntityPlayer)MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x()))) break;
                    OverlayRenderer.renderHUD(this.getModeForPlayer(), event.getPartialTicks());
                }
            }
        }
    }

    private ProbeMode getModeForPlayer() {
        EntityPlayerSP player = MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x());
        if (Config.extendedInMain && this.hasItemInMainHand((Item)ModItems.probe)) {
            return ProbeMode.EXTENDED;
        }
        return player.func_70093_af() ? ProbeMode.EXTENDED : ProbeMode.NORMAL;
    }

    private boolean hasItemInEitherHand(Item item) {
        ItemStack mainHeldItem = MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x()).func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offHeldItem = MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x()).func_184586_b(EnumHand.OFF_HAND);
        return mainHeldItem != null && mainHeldItem.func_77973_b() == item || offHeldItem != null && offHeldItem.func_77973_b() == item;
    }

    private boolean hasItemInMainHand(Item item) {
        ItemStack mainHeldItem = MinecraftTools.getPlayer((Minecraft)Minecraft.func_71410_x()).func_184586_b(EnumHand.MAIN_HAND);
        return mainHeldItem != null && mainHeldItem.func_77973_b() == item;
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
    }
}

