/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe;

import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.config.Config;
import mcjty.theoneprobe.items.ModItems;
import mcjty.theoneprobe.playerdata.PlayerGotNote;
import mcjty.theoneprobe.playerdata.PlayerProperties;
import mcjty.theoneprobe.playerdata.PropertiesDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        Config.setupStyleConfig(TheOneProbe.config);
        Config.updateDefaultOverlayStyle();
        if (TheOneProbe.config.hasChanged()) {
            TheOneProbe.config.save();
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntity().hasCapability(PlayerProperties.PLAYER_GOT_NOTE, null)) {
            event.addCapability(new ResourceLocation("theoneprobe", "Properties"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().hasCapability(PlayerProperties.PLAYER_GOT_NOTE, null)) {
            PlayerGotNote oldStore = (PlayerGotNote)event.getOriginal().getCapability(PlayerProperties.PLAYER_GOT_NOTE, null);
            PlayerGotNote newStore = PlayerProperties.getPlayerGotNote(event.getEntityPlayer());
            newStore.copyFrom(oldStore);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean success;
        PlayerGotNote note;
        if (Config.spawnNote && !(note = PlayerProperties.getPlayerGotNote(event.player)).isPlayerGotNote() && (success = event.player.field_71071_by.func_70441_a(new ItemStack((Item)ModItems.probeNote)))) {
            note.setPlayerGotNote(true);
        }
    }
}

