/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.tile.ICustomEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import java.util.UUID;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityPlayerInterface
extends TileEntityInventoryBase
implements ICustomEnergyReceiver,
IEnergyDisplay {
    public static final int DEFAULT_RANGE = 32;
    private final EnergyStorage storage = new EnergyStorage(30000);
    public UUID connectedPlayer;
    public String playerName;
    private int oldEnergy;
    private int range;

    public TileEntityPlayerInterface() {
        super(0, "playerInterface");
    }

    private EntityPlayer getPlayer() {
        EntityPlayer player;
        if (this.connectedPlayer != null && (player = this.field_145850_b.func_152378_a(this.connectedPlayer)) != null && player.func_70011_f((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) <= (double)this.range) {
            return player;
        }
        return null;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean changed = false;
            this.range = TileEntityPhantomface.upgradeRange(32, this.field_145850_b, this.field_174879_c);
            EntityPlayer player = this.getPlayer();
            if (player != null) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_() && this.storage.getEnergyStored() > 0; ++i) {
                    ITeslaConsumer cap;
                    ItemStack slot = player.field_71071_by.func_70301_a(i);
                    if (!StackUtil.isValid(slot)) continue;
                    Item item = slot.func_77973_b();
                    int received = 0;
                    if (item instanceof IEnergyContainerItem) {
                        received = ((IEnergyContainerItem)item).receiveEnergy(slot, this.storage.getEnergyStored(), false);
                    } else if (ActuallyAdditions.teslaLoaded && slot.hasCapability(TeslaUtil.teslaConsumer, null) && (cap = (ITeslaConsumer)slot.getCapability(TeslaUtil.teslaConsumer, null)) != null) {
                        received = (int)cap.givePower((long)this.storage.getEnergyStored(), false);
                    }
                    if (received <= 0) continue;
                    this.storage.extractEnergy(received, false);
                }
            }
            if (changed) {
                this.func_70296_d();
                this.sendUpdate();
            }
            if (this.storage.getEnergyStored() != this.oldEnergy && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (this.connectedPlayer != null && type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_186854_a("Player", this.connectedPlayer);
            compound.func_74778_a("PlayerName", this.playerName);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (compound.func_74764_b("PlayerLeast") && type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.connectedPlayer = compound.func_186857_a("Player");
            this.playerName = compound.func_74779_i("PlayerName");
        }
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (this.getPlayer() != null) {
            int[] theInt = new int[this.func_70302_i_()];
            for (int i = 0; i < theInt.length; ++i) {
                theInt[i] = i;
            }
            return theInt;
        }
        return new int[0];
    }

    @Override
    public int func_70297_j_() {
        EntityPlayer player = this.getPlayer();
        return player != null ? player.field_71071_by.func_70297_j_() : 0;
    }

    @Override
    public void func_174888_l() {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            player.field_71071_by.func_174888_l();
        }
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            player.field_71071_by.func_70299_a(i, stack);
        }
    }

    @Override
    public int func_70302_i_() {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            return player.field_71071_by.func_70302_i_();
        }
        return 0;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            return player.field_71071_by.func_70301_a(i);
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            return player.field_71071_by.func_70298_a(i, j);
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            return player.field_71071_by.func_70304_b(index);
        }
        return null;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        EntityPlayer player = this.getPlayer();
        return player != null && player.field_71071_by.func_94041_b(i, stack);
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return true;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }
}

