/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLaserRelayFluids
extends TileEntityLaserRelay
implements ISharingFluidHandler {
    public final ConcurrentHashMap<EnumFacing, TileEntity> handlersAround = new ConcurrentHashMap();
    private TileEntityLaserRelayEnergy.Mode mode = TileEntityLaserRelayEnergy.Mode.BOTH;

    public TileEntityLaserRelayFluids() {
        super("laserRelayFluids", LaserType.FLUID);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && this.mode == TileEntityLaserRelayEnergy.Mode.INPUT_ONLY) {
            for (EnumFacing side : this.handlersAround.keySet()) {
                WorldUtil.doFluidInteraction(this.handlersAround.get(side), this, side.func_176734_d(), Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<EnumFacing, TileEntity> old = new HashMap<EnumFacing, TileEntity>(this.handlersAround);
        boolean change = false;
        this.handlersAround.clear();
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity tile;
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            if (!this.field_145850_b.func_175667_e(pos) || (tile = this.field_145850_b.func_175625_s(pos)) == null || tile instanceof TileEntityLaserRelay || !(tile instanceof net.minecraftforge.fluids.IFluidHandler) && !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) continue;
            this.handlersAround.put(side, tile);
            TileEntity oldTile = (TileEntity)old.get(side);
            if (oldTile != null && tile.equals(oldTile)) continue;
            change = true;
        }
        if ((change || old.size() != this.handlersAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    @Override
    public int getFluidAmountToSplitShare() {
        return 0;
    }

    @Override
    public boolean doesShareFluid() {
        return false;
    }

    @Override
    public EnumFacing[] getFluidShareSides() {
        return new EnumFacing[0];
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.transmitEnergy(from, resource, doFill);
    }

    private int transmitEnergy(EnumFacing from, FluidStack stack, boolean doFill) {
        Network network;
        int transmitted = 0;
        if (stack != null && this.mode != TileEntityLaserRelayEnergy.Mode.OUTPUT_ONLY && (network = this.getNetwork()) != null) {
            transmitted = this.transferEnergyToReceiverInNeed(from, network, stack, doFill);
        }
        return transmitted;
    }

    private int transferEnergyToReceiverInNeed(EnumFacing from, Network network, FluidStack stack, boolean doFill) {
        int transmitted = 0;
        ArrayList<BlockPos> alreadyChecked = new ArrayList<BlockPos>();
        ArrayList<TileEntityLaserRelayFluids> relaysThatWork = new ArrayList<TileEntityLaserRelayFluids>();
        int totalReceiverAmount = 0;
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.field_145850_b.func_175667_e(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                TileEntity relayTile = this.field_145850_b.func_175625_s(relay);
                if (!(relayTile instanceof TileEntityLaserRelayFluids)) continue;
                TileEntityLaserRelayFluids theRelay = (TileEntityLaserRelayFluids)relayTile;
                if (theRelay.mode == TileEntityLaserRelayEnergy.Mode.INPUT_ONLY) continue;
                boolean workedOnce = false;
                for (EnumFacing facing : theRelay.handlersAround.keySet()) {
                    IFluidHandler cap;
                    if (theRelay == this && facing == from) continue;
                    TileEntity tile = theRelay.handlersAround.get(facing);
                    EnumFacing opp = facing.func_176734_d();
                    if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                        net.minecraftforge.fluids.IFluidHandler iHandler = (net.minecraftforge.fluids.IFluidHandler)tile;
                        if (!iHandler.canFill(opp, stack.getFluid()) || iHandler.fill(opp, stack, false) <= 0) continue;
                        ++totalReceiverAmount;
                        workedOnce = true;
                        continue;
                    }
                    if (!tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opp) || (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opp)) == null || cap.fill(stack, false) <= 0) continue;
                    ++totalReceiverAmount;
                    workedOnce = true;
                }
                if (!workedOnce) continue;
                relaysThatWork.add(theRelay);
            }
        }
        if (totalReceiverAmount > 0 && !relaysThatWork.isEmpty()) {
            int amountPer = stack.amount / totalReceiverAmount;
            if (amountPer <= 0) {
                amountPer = stack.amount;
            }
            for (TileEntityLaserRelayFluids theRelay : relaysThatWork) {
                for (Map.Entry<EnumFacing, TileEntity> receiver : theRelay.handlersAround.entrySet()) {
                    IFluidHandler cap;
                    FluidStack copy;
                    if (receiver == null) continue;
                    EnumFacing side = receiver.getKey();
                    EnumFacing opp = side.func_176734_d();
                    TileEntity tile = receiver.getValue();
                    if (alreadyChecked.contains(tile.func_174877_v())) continue;
                    alreadyChecked.add(tile.func_174877_v());
                    if (theRelay == this && side == from) continue;
                    if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                        net.minecraftforge.fluids.IFluidHandler iHandler = (net.minecraftforge.fluids.IFluidHandler)tile;
                        if (iHandler.canFill(opp, stack.getFluid())) {
                            copy = stack.copy();
                            copy.amount = amountPer;
                            transmitted += iHandler.fill(opp, copy, doFill);
                        }
                    } else if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opp) && (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opp)) != null) {
                        copy = stack.copy();
                        copy.amount = amountPer;
                        transmitted += cap.fill(copy, doFill);
                    }
                    if (transmitted < stack.amount) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getExtraDisplayString() {
        return "Fluid Flow: " + TextFormatting.DARK_RED + this.mode.name + TextFormatting.RESET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCompassDisplayString() {
        return TextFormatting.GREEN + "Right-Click to change!";
    }

    @Override
    public void onCompassAction(EntityPlayer player) {
        this.mode = this.mode.getNext();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74778_a("Mode", this.mode.toString());
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        String modeStrg;
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK && (modeStrg = compound.func_74779_i("Mode")) != null && !modeStrg.isEmpty()) {
            this.mode = TileEntityLaserRelayEnergy.Mode.valueOf(modeStrg);
        }
    }
}

