/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFishingNet
extends TileEntityBase {
    public int timeUntilNextDrop;

    public TileEntityFishingNet() {
        super("fishingNet");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("TimeUntilNextDrop", this.timeUntilNextDrop);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.timeUntilNextDrop = compound.func_74762_e("TimeUntilNextDrop");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && !this.isRedstonePowered && this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            if (this.timeUntilNextDrop > 0) {
                --this.timeUntilNextDrop;
                if (this.timeUntilNextDrop <= 0) {
                    LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
                    List fishables = this.field_145850_b.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_145850_b.field_73012_v, builder.func_186471_a());
                    for (ItemStack fishable : fishables) {
                        ItemStack leftover = this.storeInContainer(fishable);
                        if (!StackUtil.isValid(leftover)) continue;
                        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, leftover.func_77946_l());
                        item.lifespan = 2000;
                        this.field_145850_b.func_72838_d((Entity)item);
                    }
                }
            } else {
                int time = 15000;
                this.timeUntilNextDrop = time + this.field_145850_b.field_73012_v.nextInt(time / 2);
            }
        }
    }

    private ItemStack storeInContainer(ItemStack stack) {
        for (EnumFacing side : EnumFacing.values()) {
            IItemHandler cap;
            TileEntity tile = this.tilesAround[side.ordinal()];
            if (tile == null || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d()) || (cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) == null) continue;
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (StackUtil.isValid(stack = cap.insertItem(i, stack, false))) continue;
                return StackUtil.getNull();
            }
        }
        return stack;
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }
}

