/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ICustomEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public class TileEntityFarmer
extends TileEntityInventoryBase
implements ICustomEnergyReceiver {
    public static final int USE_PER_OPERATION = 1500;
    public final EnergyStorage storage = new EnergyStorage(100000);
    private int waitTime;
    private int checkX;
    private int checkY;
    private int lastEnergy;

    public TileEntityFarmer() {
        super(12, "farmer");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("WaitTime", this.waitTime);
            compound.func_74768_a("CheckX", this.checkX);
            compound.func_74768_a("CheckY", this.checkY);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.waitTime = compound.func_74762_e("WaitTime");
            this.checkX = compound.func_74762_e("CheckX");
            this.checkY = compound.func_74762_e("CheckY");
        }
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered) {
                if (this.waitTime > 0) {
                    --this.waitTime;
                    if (this.waitTime <= 0 && this.storage.getEnergyStored() >= 1500) {
                        boolean didSomething = false;
                        int radiusAroundCenter = 4;
                        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                        int meta = state.func_177230_c().func_176201_c(state);
                        EnumFacing side = meta == 0 ? EnumFacing.NORTH : (meta == 1 ? EnumFacing.SOUTH : (meta == 2 ? EnumFacing.WEST : EnumFacing.EAST));
                        BlockPos center = this.field_174879_c.func_177967_a(side, radiusAroundCenter + 1);
                        BlockPos plant = center.func_177982_a(this.checkX, 0, this.checkY);
                        IBlockState plantState = this.field_145850_b.func_180495_p(plant);
                        Block plantBlock = plantState.func_177230_c();
                        if (plantBlock instanceof BlockCrops) {
                            if (((BlockCrops)plantBlock).func_185525_y(plantState)) {
                                ArrayList<ItemStack> seeds = new ArrayList<ItemStack>();
                                ArrayList<ItemStack> other = new ArrayList<ItemStack>();
                                List drops = plantBlock.getDrops((IBlockAccess)this.field_145850_b, plant, plantState, 0);
                                for (ItemStack stack : drops) {
                                    if (TileEntityFarmer.getPlantableFromStack(stack) != null) {
                                        seeds.add(stack);
                                        continue;
                                    }
                                    other.add(stack);
                                }
                                boolean putSeeds = true;
                                if (!WorldUtil.addToInventory((IInventory)this, 0, 6, seeds, EnumFacing.UP, false, true)) {
                                    other.addAll(seeds);
                                    putSeeds = false;
                                }
                                if (WorldUtil.addToInventory((IInventory)this, 6, 12, other, EnumFacing.UP, false, true)) {
                                    WorldUtil.addToInventory((IInventory)this, 6, 12, other, EnumFacing.UP, true, true);
                                    if (putSeeds) {
                                        WorldUtil.addToInventory((IInventory)this, 0, 6, seeds, EnumFacing.UP, true, true);
                                    }
                                    this.field_145850_b.func_175718_b(2001, plant, Block.func_176210_f((IBlockState)plantState));
                                    this.field_145850_b.func_175698_g(plant);
                                    didSomething = true;
                                }
                            }
                        } else if (plantBlock.func_176200_f((IBlockAccess)this.field_145850_b, plant)) {
                            BlockPos farmland = plant.func_177977_b();
                            IBlockState farmlandState = this.field_145850_b.func_180495_p(farmland);
                            Block farmlandBlock = farmlandState.func_177230_c();
                            IBlockState toPlant = this.getFirstPlantablePlantFromSlots(plant);
                            if (toPlant != null) {
                                this.field_145850_b.func_180501_a(plant, toPlant, 3);
                                didSomething = true;
                            } else if (farmlandBlock instanceof BlockDirt || farmlandBlock instanceof BlockGrass) {
                                this.field_145850_b.func_180501_a(farmland, Blocks.field_150458_ak.func_176223_P(), 2);
                                this.field_145850_b.func_175698_g(plant);
                                this.field_145850_b.func_184133_a(null, farmland, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                didSomething = true;
                            }
                        }
                        if (didSomething) {
                            this.storage.extractEnergy(1500, false);
                        }
                        ++this.checkX;
                        if (this.checkX > radiusAroundCenter) {
                            this.checkX = -radiusAroundCenter;
                            ++this.checkY;
                            if (this.checkY > radiusAroundCenter) {
                                this.checkY = -radiusAroundCenter;
                            }
                        }
                    }
                } else {
                    this.waitTime = 5;
                }
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private IBlockState getFirstPlantablePlantFromSlots(BlockPos pos) {
        for (int i = 0; i < 6; ++i) {
            IBlockState state;
            IPlantable plantable;
            ItemStack stack = this.slots[i];
            if (!StackUtil.isValid(stack) || (plantable = TileEntityFarmer.getPlantableFromStack(stack)) == null || (state = plantable.getPlant((IBlockAccess)this.field_145850_b, pos)) == null || !(state.func_177230_c() instanceof BlockCrops) || !state.func_177230_c().func_176196_c(this.field_145850_b, pos)) continue;
            this.func_70298_a(i, 1);
            return state;
        }
        return null;
    }

    public static IPlantable getPlantableFromStack(ItemStack stack) {
        Block block;
        Item item = stack.func_77973_b();
        if (item instanceof IPlantable) {
            return (IPlantable)item;
        }
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof IPlantable) {
            return (IPlantable)block;
        }
        return null;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i < 6 && StackUtil.isValid(stack) && TileEntityFarmer.getPlantableFromStack(stack) != null;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot >= 6;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }
}

