/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.recipe;

import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class FuelHandler
implements IFuelHandler {
    private static final List<Fuel> FUEL_LIST = new ArrayList<Fuel>();

    public static void init() {
        ModUtil.LOGGER.info("Initializing Fuelstuffs...");
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        FuelHandler.addFuel(InitItems.itemMisc, TheMiscItems.TINY_CHAR.ordinal(), 200);
        FuelHandler.addFuel(InitItems.itemMisc, TheMiscItems.TINY_COAL.ordinal(), 200);
        FuelHandler.addFuel(InitBlocks.blockMisc, TheMiscBlocks.CHARCOAL_BLOCK.ordinal(), 16000);
        FuelHandler.addFuel(InitItems.itemMisc, TheMiscItems.BIOCOAL.ordinal(), 80);
    }

    private static void addFuel(Item item, int meta, int value) {
        FUEL_LIST.add(new Fuel(new ItemStack(item, 1, meta), value));
    }

    private static void addFuel(Block block, int meta, int value) {
        FuelHandler.addFuel(Item.func_150898_a((Block)block), meta, value);
    }

    public int getBurnTime(ItemStack stack) {
        if (StackUtil.isValid(stack)) {
            for (Fuel fuel : FUEL_LIST) {
                if (!stack.func_77969_a(fuel.fuel)) continue;
                return fuel.burnTime;
            }
        }
        return 0;
    }

    private static class Fuel {
        public ItemStack fuel;
        public int burnTime;

        public Fuel(ItemStack fuel, int burnTime) {
            this.fuel = fuel;
            this.burnTime = burnTime;
        }
    }
}

