/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.inventory.ContainerGrinder;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiInputter;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGrinder;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.io.IOException;
import java.util.Collections;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGrinder
extends GuiContainer {
    private static final ResourceLocation RES_LOC = AssetUtil.getGuiLocation("guiGrinder");
    private static final ResourceLocation RES_LOC_DOUBLE = AssetUtil.getGuiLocation("guiGrinderDouble");
    private final TileEntityGrinder tileGrinder;
    private final boolean isDouble;
    private EnergyDisplay energy;
    private GuiButton buttonAutoSplit;

    public GuiGrinder(InventoryPlayer inventoryPlayer, TileEntityBase tile) {
        this(inventoryPlayer, tile, false);
    }

    private GuiGrinder(InventoryPlayer inventory, TileEntityBase tile, boolean isDouble) {
        super((Container)new ContainerGrinder(inventory, tile, isDouble));
        this.tileGrinder = (TileEntityGrinder)tile;
        this.isDouble = isDouble;
        this.field_146999_f = 176;
        this.field_147000_g = 179;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.energy = new EnergyDisplay(this.field_147003_i + (this.isDouble ? 13 : 42), this.field_147009_r + 5, this.tileGrinder.storage);
        if (this.isDouble) {
            this.buttonAutoSplit = new GuiInputter.SmallerButton(0, this.field_147003_i - 10, this.field_147009_r, "S");
            this.field_146292_n.add(this.buttonAutoSplit);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.energy.onMouseClick(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.isDouble && button.field_146127_k == 0) {
            PacketHandlerHelper.sendButtonPacket(this.tileGrinder, button.field_146127_k);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.isDouble) {
            this.buttonAutoSplit.field_146126_j = (this.tileGrinder.isAutoSplit ? TextFormatting.DARK_GREEN : TextFormatting.RED) + "S";
        }
    }

    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        this.energy.drawOverlay(x, y);
        if (this.isDouble && this.buttonAutoSplit.func_146115_a()) {
            this.func_146283_a(Collections.singletonList(TextFormatting.BOLD + "Auto-Split Items " + (this.tileGrinder.isAutoSplit ? "On" : "Off")), x, y);
        }
    }

    public void func_146979_b(int x, int y) {
        AssetUtil.displayNameString(this.field_146289_q, this.field_146999_f, -10, this.tileGrinder);
    }

    public void func_146976_a(float f, int x, int y) {
        int i;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetUtil.GUI_INVENTORY_LOCATION);
        this.func_73729_b(this.field_147003_i, this.field_147009_r + 93, 0, 0, 176, 86);
        this.field_146297_k.func_110434_K().func_110577_a(this.isDouble ? RES_LOC_DOUBLE : RES_LOC);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 93);
        if (this.tileGrinder.firstCrushTime > 0) {
            i = this.tileGrinder.getFirstTimeToScale(23);
            this.func_73729_b(this.field_147003_i + (this.isDouble ? 51 : 80), this.field_147009_r + 40, 176, 0, 24, i);
        }
        if (this.isDouble && this.tileGrinder.secondCrushTime > 0) {
            i = this.tileGrinder.getSecondTimeToScale(23);
            this.func_73729_b(this.field_147003_i + 101, this.field_147009_r + 40, 176, 22, 24, i);
        }
        this.energy.draw();
    }

    public static class GuiGrinderDouble
    extends GuiGrinder {
        public GuiGrinderDouble(InventoryPlayer inventory, TileEntityBase tile) {
            super(inventory, tile, true);
        }
    }
}

