/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mrriegel.limelib.util.TypeAdapters;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class Utils {
    private static GsonBuilder GSONBUILDER;

    public static void init() {
    }

    public static Gson getGSON() {
        if (GSONBUILDER == null) {
            Utils.registerDefaultAdapters();
        }
        return GSONBUILDER.create();
    }

    private static void registerDefaultAdapters() {
        GSONBUILDER = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(NBTTagCompound.class, (Object)new TypeAdapters.NBTLizer()).registerTypeAdapter(ItemStack.class, (Object)new TypeAdapters.ItemStackLizer());
    }

    public static void registerGsonAdapter(Type type, Object adapter) {
        Preconditions.checkArgument((adapter instanceof JsonSerializer || adapter instanceof JsonDeserializer || adapter instanceof InstanceCreator || adapter instanceof TypeAdapter ? 1 : 0) != 0);
        Utils.getGSON();
        GSONBUILDER.registerTypeAdapter(type, adapter);
    }

    public static String getCurrentModID() {
        ModContainer mc = Loader.instance().activeModContainer();
        return mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "minecraft" : mc.getModId().toLowerCase();
    }

    public static List<Enum> getEnums(Class<? extends Enum> clazz) {
        ArrayList lis = Lists.newArrayList();
        EnumSet<? extends Enum> enums = EnumSet.allOf(clazz);
        HashMap map = Maps.newHashMap();
        for (Object e : enums) {
            Enum e2 = (Enum)e;
            map.put(e2.ordinal(), e2);
        }
        for (int i = 0; i < map.size(); ++i) {
            lis.add(map.get(i));
        }
        return lis;
    }

    public static List<Integer> split(int ii, int splits) {
        int i;
        ArrayList ints = Lists.newArrayList();
        for (i = 0; i < splits; ++i) {
            ints.add(ii / splits);
        }
        for (i = 0; i < ii % splits; ++i) {
            ints.set(i, (Integer)ints.get(i) + 1);
        }
        return ints;
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return String.valueOf((int)((double)Math.round(value) / 1000.0)) + "K";
        }
        if (value < 1000000000L) {
            return String.valueOf((int)((double)Math.round(value / 1000L) / 1000.0)) + "M";
        }
        return String.valueOf((int)((double)Math.round(value / 1000000L) / 1000.0)) + "G";
    }

    public static FakePlayer getFakePlayer(WorldServer world) {
        return FakePlayerFactory.get((WorldServer)world, (GameProfile)new GameProfile(UUID.fromString("672ec311-27a5-449e-925c-69a55980d378"), "limelib_FakePlayer"));
    }

    public static FakePlayer getFakePlayerWithItem(WorldServer world, ItemStack stack) {
        FakePlayer player = Utils.getFakePlayer(world);
        player.field_71071_by.field_70461_c = 0;
        player.field_71071_by.field_70462_a[0] = stack;
        return player;
    }

    public static RayTraceResult rayTrace(Entity entity, double distance) {
        Vec3d vec3d = entity.func_174824_e(0.0f);
        Vec3d vec3d1 = entity.func_70676_i(0.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
        return entity.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public static RayTraceResult rayTrace(EntityPlayer player) {
        return Utils.rayTrace((Entity)player, player.field_71075_bZ.field_75098_d ? 5.0 : 4.5);
    }

    public static List<Long> getLongList(List<BlockPos> list) {
        return list.stream().map(p -> p != null ? Long.valueOf(p.func_177986_g()) : null).collect(Collectors.toList());
    }

    public static List<BlockPos> getBlockPosList(List<Long> list) {
        return list.stream().map(p -> p != null ? BlockPos.func_177969_a((long)p) : null).collect(Collectors.toList());
    }

    public static String getModID(IForgeRegistryEntry<?> registerable) {
        String modID = registerable.getRegistryName().func_110624_b();
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modID);
        if (mod == null) {
            for (String s : Loader.instance().getIndexedModList().keySet()) {
                if (!s.equalsIgnoreCase(modID)) continue;
                mod = (ModContainer)Loader.instance().getIndexedModList().get(s);
                break;
            }
        }
        return mod != null ? mod.getModId() : "minecraft";
    }

    public static String getModName(IForgeRegistryEntry<?> registerable) {
        ModContainer m = (ModContainer)Loader.instance().getIndexedModList().get(Utils.getModID(registerable));
        if (m != null) {
            return m.getName();
        }
        return "Minecraft";
    }

    public static EntityPlayerMP getRandomPlayer() {
        ArrayList lis = Lists.newArrayList((Object[])FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c);
        if (lis.isEmpty()) {
            return null;
        }
        Collections.shuffle(lis);
        for (WorldServer world : lis) {
            EntityPlayerMP player = Utils.getRandomPlayer(world);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    public static EntityPlayerMP getRandomPlayer(WorldServer world) {
        if (world.field_73010_i.isEmpty()) {
            return null;
        }
        return (EntityPlayerMP)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
    }

    public static int storeBytes(byte a, byte b, byte c, byte d) {
        return a << 24 ^ b << 16 ^ c << 8 ^ d;
    }

    public static byte[] loadBytes(int a) {
        return new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
    }

    public static int storeShorts(short a, short b) {
        return a << 16 ^ b;
    }

    public static short[] loadShorts(int a) {
        return new short[]{(short)(a >> 16 & 0xFFFF), (short)(a & 0xFFFF)};
    }

    public static String toASCII(String text) {
        return Base64.getEncoder().encodeToString(text.getBytes());
    }

    public static String fromASCII(String ascii) {
        return new String(Base64.getDecoder().decode(ascii.getBytes()));
    }
}

