/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import mrriegel.limelib.helper.StackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class TypeAdapters {

    public static class NBTLizer
    implements JsonDeserializer<NBTTagCompound>,
    JsonSerializer<NBTTagCompound> {
        public JsonElement serialize(NBTTagCompound src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("NBT", src.toString());
            return json;
        }

        public NBTTagCompound deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String n = json.getAsJsonObject().get("NBT").getAsString();
            NBTTagCompound nbt = null;
            if (n != null) {
                try {
                    nbt = JsonToNBT.func_180713_a((String)n);
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
            }
            return nbt;
        }
    }

    public static class ItemStackLizer
    implements JsonDeserializer<ItemStack>,
    JsonSerializer<ItemStack> {
        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("ITEMSTACK", StackHelper.stackToString(src, false));
            json.add("NBT", context.serialize((Object)src.func_77978_p()));
            return json;
        }

        public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ItemStack stack = StackHelper.stringToStack(json.getAsJsonObject().get("ITEMSTACK").getAsString());
            if (stack != null) {
                stack.func_77982_d((NBTTagCompound)context.deserialize(json.getAsJsonObject().get("NBT"), NBTTagCompound.class));
            }
            return stack;
        }
    }

    public static class ItemLizer
    extends JsonLizer<Item> {
        @Override
        public NBTTagCompound serialize(Item t, JsonSerializationContext context) {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74768_a("item", Item.field_150901_e.func_148757_b((Object)t));
            return null;
        }

        @Override
        public Item deserialize(NBTTagCompound nbt, JsonDeserializationContext context) {
            return (Item)Item.field_150901_e.func_148754_a(nbt.func_74762_e("item"));
        }
    }

    private static abstract class JsonLizer<T>
    implements JsonDeserializer<T>,
    JsonSerializer<T> {
        private JsonLizer() {
        }

        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("NBTNBT", this.serialize(src, context).toString());
            return json;
        }

        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return this.deserialize(JsonToNBT.func_180713_a((String)json.getAsJsonObject().get("NBTNBT").getAsString()), context);
            }
            catch (NBTException e) {
                e.printStackTrace();
                return null;
            }
        }

        public abstract NBTTagCompound serialize(T var1, JsonSerializationContext var2);

        public abstract T deserialize(NBTTagCompound var1, JsonDeserializationContext var2);
    }
}

