/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.ItemHandlerHelper;

public class StackWrapper {
    ItemStack stack;
    int size;

    public StackWrapper(ItemStack stack, int size) {
        if (stack == null) {
            throw new NullPointerException();
        }
        this.stack = stack.func_77946_l();
        this.size = size;
    }

    private StackWrapper() {
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound c = compound.func_74775_l("stack");
        this.stack = ItemStack.func_77949_a((NBTTagCompound)c);
        this.size = compound.func_74762_e("size");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound c = new NBTTagCompound();
        this.stack.func_77955_b(c);
        compound.func_74782_a("stack", (NBTBase)c);
        compound.func_74768_a("size", this.size);
        return compound;
    }

    public String toString() {
        return "[" + this.size + "x" + this.stack.func_77973_b().func_77658_a() + "@" + this.stack.func_77952_i() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackWrapper)) {
            return false;
        }
        StackWrapper o = (StackWrapper)obj;
        return o.stack.func_77969_a(this.stack) && ItemStack.func_77970_a((ItemStack)o.stack, (ItemStack)this.stack);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException();
        }
        this.stack = stack.func_77946_l();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public StackWrapper copy() {
        return new StackWrapper(this.stack.func_77946_l(), this.size);
    }

    public static StackWrapper loadStackWrapperFromNBT(NBTTagCompound nbt) {
        StackWrapper wrap = new StackWrapper();
        wrap.readFromNBT(nbt);
        return wrap.getStack() != null ? wrap : null;
    }

    public static List<ItemStack> toStackList(List<StackWrapper> list) {
        ArrayList lis = Lists.newArrayList();
        for (StackWrapper s : list) {
            if (s == null || s.getStack() == null) continue;
            int maxstacksize = s.getStack().func_77976_d();
            int stacks = s.size / maxstacksize + (s.size % maxstacksize != 0 ? 1 : 0);
            for (int i = 0; i < stacks; ++i) {
                ItemStack toAdd = s.getStack().func_77946_l();
                toAdd.field_77994_a = s.size == maxstacksize ? maxstacksize : (i < stacks - 1 ? maxstacksize : s.size % maxstacksize);
                lis.add(toAdd);
            }
        }
        return lis;
    }

    public static List<ItemStack> toStackList(StackWrapper wrap) {
        return StackWrapper.toStackList(Collections.singletonList(wrap));
    }

    public static List<StackWrapper> toWrapperList(List<ItemStack> list) {
        ArrayList lis = Lists.newArrayList();
        for (ItemStack s : list) {
            if (s == null) continue;
            boolean added = false;
            for (int i = 0; i < lis.size(); ++i) {
                ItemStack stack = ((StackWrapper)lis.get(i)).getStack().func_77946_l();
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                ((StackWrapper)lis.get(i)).setSize(((StackWrapper)lis.get(i)).getSize() + s.field_77994_a);
                added = true;
                break;
            }
            if (added) continue;
            lis.add(new StackWrapper(s, s.field_77994_a));
        }
        return lis;
    }
}

