/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class GlobalBlockPos {
    private BlockPos pos;
    private int dimension;

    public GlobalBlockPos(BlockPos pos, int dimension) {
        this.pos = pos;
        this.dimension = dimension;
    }

    public GlobalBlockPos(BlockPos pos, World world) {
        this(pos, world.field_73011_w.getDimension());
    }

    private GlobalBlockPos() {
    }

    public static GlobalBlockPos fromTile(TileEntity tile) {
        if (tile == null) {
            return null;
        }
        return new GlobalBlockPos(tile.func_174877_v(), tile.func_145831_w());
    }

    public String toString() {
        return "GlobalBlockPos [pos=" + this.pos + ", dimension=" + this.dimension + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension;
        result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalBlockPos other = (GlobalBlockPos)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        return !(this.pos == null ? other.pos != null : !this.pos.equals((Object)other.pos));
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public World getWorld() {
        return DimensionManager.getWorld((int)this.dimension);
    }

    @Deprecated
    public World getWorld(World world) {
        return this.getWorld();
    }

    public TileEntity getTile() {
        if (this.getWorld() == null) {
            return null;
        }
        return this.getWorld().func_175625_s(this.getPos());
    }

    @Deprecated
    public TileEntity getTile(World world) {
        return this.getTile();
    }

    public IBlockState getBlockState() {
        return this.getWorld().func_180495_p(this.getPos());
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.pos = compound.func_74764_b("Gpos") ? BlockPos.func_177969_a((long)compound.func_74763_f("Gpos")) : null;
        this.dimension = compound.func_74762_e("Gdim");
    }

    public void writeToNBT(NBTTagCompound compound) {
        if (this.pos != null) {
            compound.func_74772_a("Gpos", this.pos.func_177986_g());
        }
        compound.func_74768_a("Gdim", this.dimension);
    }

    public static GlobalBlockPos loadGlobalPosFromNBT(NBTTagCompound nbt) {
        GlobalBlockPos pos = new GlobalBlockPos();
        pos.readFromNBT(nbt);
        return pos.getPos() != null ? pos : null;
    }
}

