/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.limelib.util;

import com.google.common.collect.Maps;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.stream.Collectors;
import mrriegel.limelib.datapart.CapabilityDataPart;
import mrriegel.limelib.datapart.DataPart;
import mrriegel.limelib.datapart.DataPartRegistry;
import mrriegel.limelib.network.EnergySyncMessage;
import mrriegel.limelib.network.PacketHandler;
import mrriegel.limelib.network.PlayerClickMessage;
import mrriegel.limelib.tile.CommonTile;
import mrriegel.limelib.tile.IOwneable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class EventHandler {
    private static Map<Side, Map<String, Long>> lastClicks = null;

    @SubscribeEvent
    public static void left(PlayerInteractEvent.LeftClickBlock event) {
        IOwneable o;
        TileEntity tile;
        if (event.getEntityPlayer() != null && (tile = event.getWorld().func_175625_s(event.getPos())) instanceof IOwneable && !(o = (IOwneable)tile).canAccess(event.getEntityPlayer().getDisplayNameString())) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void right(PlayerInteractEvent.RightClickBlock event) {
        IOwneable o;
        TileEntity tile;
        if (event.getEntityPlayer() != null && (tile = event.getWorld().func_175625_s(event.getPos())) instanceof IOwneable && !(o = (IOwneable)tile).canAccess(event.getEntityPlayer().getDisplayNameString())) {
            event.setResult(Event.Result.DENY);
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            DataPartRegistry reg;
            try {
                if (event.world.func_82737_E() % 4L == 0L) {
                    for (CommonTile tile : event.world.field_147482_g.stream().filter(t -> t instanceof CommonTile && !t.func_145837_r()).collect(Collectors.toList())) {
                        if (!tile.needsSync()) continue;
                        tile.sync();
                        tile.setSyncDirty(false);
                    }
                }
            }
            catch (ConcurrentModificationException it) {
                // empty catch block
            }
            if ((reg = DataPartRegistry.get(event.world)) != null) {
                for (DataPart part : reg.getParts().stream().filter(p -> p != null && event.world.func_175667_e(p.getPos())).collect(Collectors.toList())) {
                    part.updateServer(event.world);
                    ++part.ticksExisted;
                    if (event.world.func_82737_E() % 200L != 0L) continue;
                    reg.sync(part.getPos(), false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER && event.player.field_70170_p.func_82737_E() % (long)(event.player.func_70093_af() ? 8 : 20) == 0L) {
            PacketHandler.sendTo(new EnergySyncMessage((EntityPlayerMP)event.player), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void attachWorld(AttachCapabilitiesEvent<World> event) {
        event.addCapability(DataPartRegistry.LOCATION, (ICapabilityProvider)new CapabilityDataPart.CapaProvider((World)event.getObject()));
    }

    @SubscribeEvent
    public static void login(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            ((IThreadListener)event.player.field_70170_p).func_152344_a(() -> {
                DataPartRegistry reg = DataPartRegistry.get(event.player.field_70170_p);
                if (reg != null) {
                    reg.getParts().forEach(p -> reg.sync(p.getPos(), true));
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void interact(PlayerInteractEvent event) {
        boolean server;
        boolean left = event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.LeftClickEmpty;
        boolean right = event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickItem;
        boolean bl = server = event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.RightClickItem;
        if ((left || right) && !event.isCanceled()) {
            DataPart part = DataPart.rayTrace(event.getEntityPlayer());
            Side side = event.getSide();
            if (part != null && part.clientValid() && !event.getEntityPlayer().func_70093_af()) {
                if (lastClicks == null) {
                    lastClicks = Maps.newTreeMap();
                    lastClicks.put(Side.SERVER, Maps.newTreeMap());
                    lastClicks.put(Side.CLIENT, Maps.newTreeMap());
                }
                boolean touch = false;
                if (!lastClicks.get(side).containsKey(event.getEntityPlayer().getDisplayNameString()) || System.currentTimeMillis() - lastClicks.get(side).get(event.getEntityPlayer().getDisplayNameString()) > (long)(left ? 150 : 40)) {
                    if (left) {
                        touch = part.onLeftClicked(event.getEntityPlayer(), event.getHand());
                    } else {
                        touch = part.onRightClicked(event.getEntityPlayer(), event.getHand());
                        event.getEntityPlayer().func_184609_a(event.getHand());
                    }
                    if (!server && event.getWorld().field_72995_K) {
                        PacketHandler.sendToServer(new PlayerClickMessage(part.getPos(), event.getHand(), left));
                    }
                    lastClicks.get(side).put(event.getEntityPlayer().getDisplayNameString(), System.currentTimeMillis());
                }
                if (!touch) {
                    return;
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                event.setResult(Event.Result.DENY);
                if (event instanceof PlayerInteractEvent.LeftClickBlock) {
                    ((PlayerInteractEvent.LeftClickBlock)event).setUseBlock(Event.Result.DENY);
                    ((PlayerInteractEvent.LeftClickBlock)event).setUseItem(Event.Result.DENY);
                } else if (event instanceof PlayerInteractEvent.RightClickBlock) {
                    ((PlayerInteractEvent.RightClickBlock)event).setUseBlock(Event.Result.DENY);
                    ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.DENY);
                }
            }
        }
    }
}

